/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.base.ui.views.actions;

import com.clustercontrol.action.FacilityTree;
import com.clustercontrol.cloud.aws.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.aws.base.resources.AvailabilityZone;
import com.clustercontrol.cloud.aws.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.aws.base.resources.GroupIdentifier;
import com.clustercontrol.cloud.aws.base.resources.Image;
import com.clustercontrol.cloud.aws.base.resources.Subnet;
import com.clustercontrol.cloud.aws.base.ui.dialogs.CreateInstanceDialog;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudComputeService;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.presenter.ICloudInstanceBackup;
import com.clustercontrol.cloud.presenter.RestoreCloudInstanceRequest;
import com.clustercontrol.cloud.ui.views.InstanceMonitorService;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class RestoreInstanceAction
extends SingleSelectionActionEx {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String msgRestoreInstanceConfirm = this.messages.getString("message.confirm_some_action_to_something", new Object[]{"word.instance", "word.restore"});
    private String msgRestoreInstanceResult = this.messages.getString("message.result_some_action_to_something", new Object[]{"word.instance", "word.restore"});

    protected void invoke(IAction action) throws InvocationException {
        CreateInstanceDialog.Model m;
        CreateInstanceDialog dialog = new CreateInstanceDialog(this.viewPart.getSite().getShell());
        ICloudInstanceBackup backup = (ICloudInstanceBackup)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        CloudResourceProviderImpl resourceProvider = new CloudResourceProviderImpl(backup.getAccountResourceId());
        String region = backup.getRegion();
        if (region != null) {
            m = new CreateInstanceDialog.Model();
            m.setRegionName(region);
            m.setFacilityId(backup.getBackupedData().getFacilityId());
            m.setFacilityName(backup.getBackupedData().getFacilityName());
            m.setNodeName(backup.getBackupedData().getNodeName());
            m.setReplaceNode(true);
            m.setImage(new Image());
            m.getImage().setImageId(backup.getInstanceBackupId());
            m.getImage().setName(backup.getName());
            m.setDescription(backup.getDescription());
            ObjectMapper om = new ObjectMapper();
            ObjectReader dr = om.reader(CreateInstanceDialog.InstanceDetail.class);
            try {
                CreateInstanceDialog.InstanceDetail detail = (CreateInstanceDialog.InstanceDetail)dr.readValue(backup.getBackupedData().getInstanceDetail());
                if (detail != null) {
                    m.setKeyName(detail.keyName);
                    m.setMonitoring(detail.monitoring);
                    m.setDisableApiTermination(detail.disableApiTermination);
                    m.setInstanceInitiatedShutdownBehavior(detail.instanceInitiatedShutdownBehavior);
                    m.setEbsOptimized(detail.ebsOptimized);
                    m.setRootBlockDevice(detail.rootBlockDevice);
                    for (Subnet subnet : resourceProvider.getSubnetsByRegion(region)) {
                        if (!subnet.getSubnetId().equals(detail.subnetId)) continue;
                        m.setSubnet(subnet);
                        break;
                    }
                    ArrayList<GroupIdentifier> securities = new ArrayList<GroupIdentifier>();
                    for (GroupIdentifier security : resourceProvider.getSecurityGroupsByRegion(region)) {
                        for (String securityId : detail.securityGroupIds) {
                            if (!security.getGroupId().equals(securityId)) continue;
                            securities.add(security);
                        }
                    }
                    m.setSecurityGroups(securities);
                }
            }
            catch (IOException e) {
                throw new InvocationException((Throwable)e);
            }
            dialog.setInput(m);
        }
        dialog.setCloudInfoProvider(resourceProvider);
        dialog.setBehavior(new CreateInstanceDialog.DialogBehavior(){

            @Override
            public void setupFacilityId(Text facilityId) {
                facilityId.setText(this.input.getFacilityId());
            }

            @Override
            public void setupFacilityName(Text facilityName) {
                if (this.input.getFacilityName() != null) {
                    facilityName.setText(this.input.getFacilityName());
                }
            }

            @Override
            public void setupReplaceNode(Button btnReplaceNode) {
                btnReplaceNode.setSelection(true);
            }

            @Override
            public void setupDescription(Text description) {
                if (this.input.getDescription() != null) {
                    description.setText(this.input.getDescription());
                }
            }

            @Override
            public void setupNodeName(Text nodeName) {
                nodeName.setText(this.input.getNodeName());
            }

            @Override
            public void setupRegion(Combo region) {
                String regionLocaleName = this.messages.getString(this.input.getRegionName());
                region.add(regionLocaleName);
                region.setData(regionLocaleName, (Object)this.input.getRegionName());
                region.select(0);
                region.setEnabled(false);
            }

            @Override
            public void setupAvailabilityZone(Combo availabilityZone) {
                for (AvailabilityZone zone : this.provider.getAvailabilityZones(this.input.getRegionName())) {
                    availabilityZone.add(zone.getZoneName());
                }
                if (this.input != null && this.input.getAvailabilityZone() != null && availabilityZone.indexOf(this.input.getAvailabilityZone().getZoneName()) != -1) {
                    availabilityZone.select(availabilityZone.indexOf(this.input.getAvailabilityZone().getZoneName()));
                } else if (availabilityZone.getItemCount() > 0) {
                    availabilityZone.select(0);
                }
            }

            @Override
            public void setupKeyPair(Combo keyPair) {
                for (String keyName : this.provider.getKeyNames(this.input.getRegionName())) {
                    keyPair.add(keyName);
                }
                if (keyPair.getItemCount() > 0) {
                    if (this.input.getKeyName() != null && keyPair.indexOf(this.input.getKeyName()) != -1) {
                        keyPair.select(keyPair.indexOf(this.input.getKeyName()));
                    } else if (keyPair.getItemCount() > 0) {
                        keyPair.select(0);
                    }
                    keyPair.setEnabled(true);
                } else {
                    keyPair.setEnabled(false);
                }
            }

            @Override
            public void setupSelectImageFlg(Button rdoAmi, Button rdoTemplate) {
                rdoAmi.setSelection(true);
                rdoAmi.setEnabled(false);
                rdoTemplate.setSelection(false);
                rdoTemplate.setEnabled(false);
            }

            @Override
            public void setupAmi(Text ami, Button selectAmi) {
                ami.setText("(" + this.input.getImage().getImageId() + ") " + this.input.getImage().getName());
                ami.setData((Object)this.input.getImage());
                ami.setEditable(false);
                selectAmi.setEnabled(false);
            }

            @Override
            public void setupTemplate(Button useTemplate, Combo template, Button editArgument) {
                useTemplate.setEnabled(false);
                template.setEnabled(false);
                editArgument.setEnabled(false);
            }
        });
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.msgRestoreInstanceConfirm)) {
                String detailJson;
                m = dialog.getOutput();
                RestoreCloudInstanceRequest request = new RestoreCloudInstanceRequest();
                CreateInstanceDialog.InstanceDetail detail = new CreateInstanceDialog.InstanceDetail();
                detail.subnetId = m.getSubnet() != null ? m.getSubnet().getSubnetId() : null;
                detail.keyName = m.getKeyName();
                detail.monitoring = m.getMonitoring();
                detail.disableApiTermination = m.getDisableApiTermination();
                detail.instanceInitiatedShutdownBehavior = m.getInstanceInitiatedShutdownBehavior();
                detail.ebsOptimized = m.getEbsOptimized();
                if (m.getRootBlockDevice() != null) {
                    detail.rootBlockDevice = new CreateInstanceDialog.EbsBlockDevice();
                    detail.rootBlockDevice.volumeSize = m.getRootBlockDevice().volumeSize;
                    detail.rootBlockDevice.volumeType = m.getRootBlockDevice().volumeType;
                    detail.rootBlockDevice.deleteOnTermination = m.getRootBlockDevice().deleteOnTermination;
                }
                if (m.getSecurityGroups() != null) {
                    detail.securityGroupIds = new ArrayList<String>();
                    for (GroupIdentifier securityGroup : m.getSecurityGroups()) {
                        detail.securityGroupIds.add(securityGroup.getGroupId());
                    }
                }
                ObjectMapper om = new ObjectMapper();
                ObjectWriter dw = om.writerWithType(CreateInstanceDialog.InstanceDetail.class);
                try {
                    detailJson = dw.writeValueAsString((Object)detail);
                }
                catch (Exception e) {
                    throw new CloudModelException((Throwable)e);
                }
                request.setZone(m.getZone());
                if (m.getImage() != null) {
                    request.setInstanceBackupId(m.getImage().getImageId());
                }
                request.setFlavor(m.getFlavor());
                request.setFacilityId(m.getFacilityId());
                request.setFacilityName(m.getFacilityName());
                request.setDescription(m.getDescription());
                request.setNodeName(m.getNodeName());
                request.setReplaceNode(m.getReplaceNode());
                request.setInstanceDetail(detailJson);
                IAccountResource.IRegion r = backup.getCloudInstanceBackupManager().getCloudComputeService().getRegion();
                final ICloudInstance instance = ((ICloudComputeService)r.getAccountResource().getRegion(m.getRegionName()).getCloudService(ICloudComputeService.class)).getInstanceManager().restoreCloudInstance(request);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgRestoreInstanceResult);
                this.viewPart.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        InstanceMonitorService.getInstanceMonitorService().startMonitor(instance, new ICloudInstance.StateType[]{ICloudInstance.StateType.running, ICloudInstance.StateType.terminated, ICloudInstance.StateType.stopped});
                        FacilityTree.refresh();
                    }
                });
            } else {
                return;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        ICloudInstanceBackup backup = (ICloudInstanceBackup)((IStructuredSelection)selection).getFirstElement();
        if (backup == null || backup.getRestoreStatus() == null || backup.getRestoreStatus().equals(ICloudInstanceBackup.RestoreStatus.unavailable.name())) {
            action.setEnabled(false);
        }
    }
}

