/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.base.ui.views.actions;

import com.clustercontrol.cloud.aws.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.aws.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.aws.base.ui.dialogs.CreateStorageDialog;
import com.clustercontrol.cloud.presenter.CreateStorageRequest;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudComputeService;
import com.clustercontrol.cloud.presenter.ICloudStorageBackup;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class RestoreStorageAction
extends SingleSelectionActionEx {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String msgRestoreStorageConfirm = this.messages.getString("message.confirm_some_action_to_something", new Object[]{"word.storage", "word.restore"});
    private String msgRestoreStorageResult = this.messages.getString("message.result_some_action_to_something", new Object[]{"word.storage", "word.restore"});

    protected void invoke(IAction action) throws InvocationException {
        final ICloudStorageBackup backup = (ICloudStorageBackup)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        final IAccountResource.IRegion region = backup.getCloudStorageBackupManager().getRegion().getAccountResource().getRegion(backup.getRegion());
        CloudResourceProviderImpl provider = new CloudResourceProviderImpl(region.getAccountResource().getAccountResourceId());
        CreateStorageDialog dialog = new CreateStorageDialog(this.viewPart.getSite().getShell());
        CreateStorageDialog.DialogData input = new CreateStorageDialog.DialogData();
        input.setFlavor(backup.getBackupedData().getFlavor());
        input.setStorageSize(backup.getBackupedData().getSize());
        input.setZone(backup.getBackupedData().getZone());
        ObjectMapper om = new ObjectMapper();
        ObjectReader dr = om.reader(CreateStorageDialog.StorageDetail.class);
        try {
            CreateStorageDialog.StorageDetail detail = (CreateStorageDialog.StorageDetail)dr.readValue(backup.getBackupedData().getStorageDetail());
            input.setIops(detail.iops);
        }
        catch (IOException e) {
            throw new InvocationException((Throwable)e);
        }
        dialog.setInput(input);
        dialog.setCloudInfoProvider(provider);
        dialog.setBehavior(new CreateStorageDialog.DialogBehavior(){

            @Override
            public void setupRegion(Combo cmbRegion) {
                super.setupRegion(cmbRegion);
                if (region != null && region.getRegion() != null && cmbRegion.indexOf(region.getRegionName()) != -1) {
                    cmbRegion.select(cmbRegion.indexOf(region.getRegionName()));
                } else if (cmbRegion.getItemCount() > 0) {
                    cmbRegion.select(0);
                }
            }

            @Override
            public void setupVolumeName(Text txtVolumeName) {
                if (backup.getSnapshotName() != null) {
                    txtVolumeName.setText(backup.getSnapshotName());
                }
            }

            @Override
            public void setupSnapshot(Combo cmbSnapshot) {
                if (backup.getStorageBackupId() != null) {
                    String label = backup.getSnapshotName() + "(" + backup.getStorageBackupId() + ")";
                    cmbSnapshot.add(label);
                    cmbSnapshot.setData(label, (Object)backup.getStorageBackupId());
                    cmbSnapshot.select(0);
                }
            }
        });
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.msgRestoreStorageConfirm)) {
                CreateStorageDialog.DialogData output = dialog.getOutput();
                CreateStorageDialog.StorageDetail detail = new CreateStorageDialog.StorageDetail();
                detail.iops = output.getIops();
                ObjectWriter dw = om.writerWithType(CreateStorageDialog.StorageDetail.class);
                String storageDetail = null;
                try {
                    storageDetail = dw.writeValueAsString((Object)detail);
                }
                catch (IOException e) {
                    throw new InvocationException((Throwable)e);
                }
                output.setStorageDetail(storageDetail);
                ((ICloudComputeService)region.getAccountResource().getRegion(output.getRegion()).getCloudService(ICloudComputeService.class)).getStorageManager().createCloudStorage((CreateStorageRequest)output);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgRestoreStorageResult);
            } else {
                return;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        ICloudStorageBackup backup = (ICloudStorageBackup)((IStructuredSelection)selection).getFirstElement();
        if (backup == null || backup.getRestoreStatus() == null || backup.getRestoreStatus().equals(ICloudStorageBackup.RestoreStatus.unavailable.name())) {
            action.setEnabled(false);
        }
    }
}

