/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.presenter;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class CacheService {
    private Map<Object, Map<Class<?>, Object>> map = new WeakHashMap();
    private static CacheService singleton;

    private CacheService() {
    }

    public synchronized <T> void put(Object key, Class<T> type, T value) {
        Map<Class<?>, Object> valueMap = this.map.get(key);
        if (valueMap == null) {
            valueMap = new HashMap();
            this.map.put(key, valueMap);
        }
        valueMap.put(type, value);
    }

    public synchronized <T> T get(Object key, Class<T> type) {
        Map<Class<?>, Object> valueMap = this.map.get(key);
        if (valueMap == null) {
            return null;
        }
        Object result = valueMap.get(type);
        valueMap.remove(type);
        return (T)result;
    }

    public synchronized Object remove(Object key) {
        return this.map.remove(key);
    }

    public static synchronized CacheService getSingleton() {
        if (singleton == null) {
            singleton = new CacheService();
        }
        return singleton;
    }
}

