/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.annotation.Import;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.CloudUserManager;
import com.clustercontrol.cloud.presenter.ICloudUser;
import com.clustercontrol.cloud.presenter.InternalComponent;
import com.clustercontrol.cloud.presenter.ModifyCloudUserRequest;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;

public class CloudUser
extends InternalComponent<CloudUserManager, com.clustercontrol.ws.cloud.CloudUser>
implements ICloudUser {
    private String cloudUserId;
    private String cloudUserName;
    private String description;
    private String accountResourceId;
    private String cloudUserType;
    private String roleId;
    private String accessKey;
    private String secretKey;
    private Long regDate;
    private String regUser;
    private Long updateDate;
    private String updateUser;
    private CloudUserManager cloudUserManager;

    public CloudUser(CloudUserManager container) {
        super(container);
        this.cloudUserManager = container;
    }

    @Override
    public String getCloudUserId() {
        return this.cloudUserId;
    }

    @Override
    public String getCloudUserName() {
        return this.cloudUserName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getAccountResourceId() {
        return this.accountResourceId;
    }

    @Override
    public String getCloudUserType() {
        return this.cloudUserType;
    }

    @Override
    public String getRoleId() {
        return this.roleId;
    }

    @Override
    public String getAccessKey() {
        return this.accessKey;
    }

    @Override
    public String getSecretKey() {
        return this.secretKey;
    }

    @Override
    public Long getRegDate() {
        return this.regDate;
    }

    @Override
    public String getRegUser() {
        return this.regUser;
    }

    @Override
    public Long getUpdateDate() {
        return this.updateDate;
    }

    @Override
    public String getUpdateUser() {
        return this.updateUser;
    }

    @Override
    public CloudUserManager getCloudUserManager() {
        return this.cloudUserManager;
    }

    @Import
    public void setCloudUserId(String cloudUserId) {
        this.internalSet("cloudUserId", ICloudUser.p2.cloudUserId, cloudUserId);
    }

    @Import
    public void setCloudUserName(String cloudUserName) {
        this.internalSet("cloudUserName", ICloudUser.p2.cloudUserName, cloudUserName);
    }

    @Import
    public void setDescription(String description) {
        this.internalSet("description", ICloudUser.p2.description, description);
    }

    @Import
    public void setAccountResourceId(String accountResourceId) {
        this.internalSet("accountResourceId", ICloudUser.p2.accountResourceId, accountResourceId);
    }

    public void setCloudUserType(String cloudUserType) {
        this.internalSet("cloudUserType", ICloudUser.p2.cloudUserType, cloudUserType);
    }

    @Import
    public void setRoleId(String roleId) {
        this.internalSet("roleId", ICloudUser.p2.roleId, roleId);
    }

    @Import
    public void setRegDate(Long regDate) {
        this.internalSet("regDate", ICloudUser.p2.regDate, regDate);
    }

    @Import
    public void setRegUser(String regUser) {
        this.internalSet("regUser", ICloudUser.p2.regUser, regUser);
    }

    @Import
    public void setUpdateDate(Long updateDate) {
        this.internalSet("updateDate", ICloudUser.p2.updateDate, updateDate);
    }

    @Import
    public void setUpdateUser(String updateUser) {
        this.internalSet("updateUser", ICloudUser.p2.updateUser, updateUser);
    }

    @Import
    public void setAccessKey(String accessKey) {
        this.internalSet("accessKey", ICloudUser.p2.accessKey, accessKey);
    }

    @Import
    public void setSecretKey(String secretKey) {
        this.internalSet("secretKey", ICloudUser.p2.secretKey, secretKey);
    }

    @Override
    public boolean equalValues(com.clustercontrol.ws.cloud.CloudUser source) {
        return this.getCloudUserId().equals(source.getCloudUserId());
    }

    @Override
    public com.clustercontrol.ws.cloud.CloudUser getSource() throws CloudModelException {
        try {
            return this.getCloudUserManager().getAccountResource().getAccountResourceManager().getCloudResourceManager().getEndpoint(CloudEndpoint.class).getCloudUser(this.cloudUserId);
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    protected void overwrite(com.clustercontrol.ws.cloud.CloudUser source) {
        ControlUtil.importObject(this, source);
        this.setCloudUserType(source.getCloudUserType().name());
    }

    @Override
    public CloudUser modifyCloudUser(ModifyCloudUserRequest modifyCloudUserRequest) {
        com.clustercontrol.ws.cloud.ModifyCloudUserRequest wsModifyCloudUserRequest = new com.clustercontrol.ws.cloud.ModifyCloudUserRequest();
        ControlUtil.exportObject(modifyCloudUserRequest, wsModifyCloudUserRequest);
        try {
            com.clustercontrol.ws.cloud.CloudUser reWsCloudUser = this.getCloudUserManager().getAccountResource().getAccountResourceManager().getCloudResourceManager().getEndpoint(CloudEndpoint.class).modifyCloudUser(wsModifyCloudUserRequest);
            this.overwrite(reWsCloudUser);
            return this;
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }
}

