/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.cloud.presenter.IEndpointManager;
import com.clustercontrol.util.EndpointManager;
import com.clustercontrol.util.LoginManager;
import com.clustercontrol.ws.access.AccessEndpoint;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudEndpointService;
import com.clustercontrol.ws.jobmanagement.JobEndpoint;
import com.clustercontrol.ws.repository.RepositoryEndpoint;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.log4j.Logger;
import org.eclipse.jface.preference.IPreferenceStore;

public class EndpointManager
implements IEndpointManager {
    private static final ThreadLocal<CloudEndpoint> cloudEndpoint = new ThreadLocal<CloudEndpoint>(){

        @Override
        protected CloudEndpoint initialValue() {
            InvocationHandler h = new InvocationHandler(){
                private String currentUserId;
                private String currentPassword;
                private String currentUrl;
                private CloudEndpoint endpoint;

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    String userId;
                    if (this.endpoint == null) {
                        userId = LoginManager.getUserId();
                        String password = LoginManager.getPassword();
                        String url = LoginManager.getUrl();
                        this.endpoint = EndpointManager.createCloudEndpoint(userId, password, url);
                        this.currentUserId = userId;
                        this.currentPassword = password;
                        this.currentUrl = url;
                    } else {
                        userId = LoginManager.getUserId();
                        String password = LoginManager.getPassword();
                        String url = LoginManager.getUrl();
                        if (userId == null || password == null || url == null) {
                            throw new IllegalStateException();
                        }
                        if (!(userId.equals(this.currentUserId) && password.equals(this.currentPassword) && url.equals(this.currentUrl))) {
                            this.endpoint = EndpointManager.createCloudEndpoint(userId, password, url);
                            this.currentUserId = userId;
                            this.currentPassword = password;
                            this.currentUrl = url;
                        }
                    }
                    try {
                        return method.invoke((Object)this.endpoint, args);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getCause();
                    }
                }
            };
            return (CloudEndpoint)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{CloudEndpoint.class}, h);
        }
    };

    private List<EndpointManager.EndpointSetting> getEndpointSetting(Class<?> clazz) {
        if (AccessEndpoint.class == clazz) {
            return com.clustercontrol.util.EndpointManager.getAccessEndpoint();
        }
        if (RepositoryEndpoint.class == clazz) {
            return com.clustercontrol.util.EndpointManager.getRepositoryEndpoint();
        }
        if (JobEndpoint.class == clazz) {
            return com.clustercontrol.util.EndpointManager.getJobEndpoint();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized <T> T getEndpoint(final Class<T> clazz) {
        Object endpoint = null;
        if (clazz == CloudEndpoint.class) {
            endpoint = cloudEndpoint.get();
        } else {
            InvocationHandler h = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    WebServiceException wse = null;
                    for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.this.getEndpointSetting(clazz)) {
                        try {
                            Object endpoint = endpointSetting.getEndpoint();
                            return method.invoke(endpoint, args);
                        }
                        catch (InvocationTargetException e) {
                            if (!(e.getCause() instanceof WebServiceException)) {
                                throw e.getCause();
                            }
                            Logger logger = Logger.getLogger(EndpointManager.class);
                            logger.warn((Object)("calling " + method.getName()), e.getCause());
                            com.clustercontrol.util.EndpointManager.changeEndpoint();
                            wse = (WebServiceException)e.getCause();
                        }
                    }
                    throw wse;
                }
            };
            endpoint = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clazz}, h);
        }
        return (T)endpoint;
    }

    private static CloudEndpoint createCloudEndpoint(String userId, String password, String url) {
        CloudEndpoint endpoint = null;
        try {
            String urlCloudEndpoint = LoginManager.getUrl() + CloudEndpointService.class.getSimpleName();
            CloudEndpointService service = new CloudEndpointService(new URL(urlCloudEndpoint + "?wsdl"), new QName("http://cloud.ws.clustercontrol.com", CloudEndpointService.class.getSimpleName()));
            endpoint = service.getCloudEndpointPort();
            BindingProvider bp = (BindingProvider)endpoint;
            bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", urlCloudEndpoint);
            bp.getRequestContext().put("javax.xml.ws.security.auth.username", userId);
            bp.getRequestContext().put("javax.xml.ws.security.auth.password", password);
            IPreferenceStore store = ClusterControlPlugin.getDefault().getPreferenceStore();
            int httpConnectTimeout = store.getInt("httpConnectTimeout");
            int httpRequestTimeout = store.getInt("httpRequestTimeout");
            bp.getRequestContext().put("com.sun.xml.internal.ws.connect.timeout", httpConnectTimeout * 1000);
            bp.getRequestContext().put("com.sun.xml.internal.ws.request.timeout", httpRequestTimeout * 1000);
            ((SOAPBinding)bp.getBinding()).setMTOMEnabled(true);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return endpoint;
    }

    @Override
    public String getAccountName() {
        return LoginManager.getUserId();
    }
}

