/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views.actions;

import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.presenter.ICloudStorage;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

public class DeleteStorageAction
extends SingleSelectionActionEx {
    public static final String ID = "com.clustercontrol.cloud.ui.views.actions.DeleteStorageAction";
    private MessageManager messages = MessageManager.getInstance("messages");
    private String msgDeleteStorageConfirm = this.messages.getString("message.confirm_some_action_to_subjects", new Object[]{"word.storage", "word.remove"});
    private String msgDeleteStorageResult = this.messages.getString("message.result_some_action_to_something", new Object[]{"word.storage", "word.remove"});

    @Override
    protected void invoke(IAction action) throws InvocationException {
        ICloudStorage storage = (ICloudStorage)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)(this.msgDeleteStorageConfirm + "\n" + storage.getStorageId()))) {
            storage.getCloudStorageManager().removeCloudStorage(storage.getStorageId());
            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgDeleteStorageResult);
        }
    }

    @Override
    protected boolean canEnabled(IStructuredSelection selection) {
        ICloudStorage storage = (ICloudStorage)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        return !ICloudStorage.RegistStateType.deleted.name().equals(storage.getRegistState());
    }
}

