/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views.actions;

import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.presenter.CloudTemplate;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.presenter.ICloudTemplateManager;
import com.clustercontrol.cloud.presenter.RunJobRequest;
import com.clustercontrol.cloud.ui.dialogs.StopInstanceDialog;
import com.clustercontrol.cloud.ui.views.InstanceMonitorService;
import com.clustercontrol.cloud.ui.views.InstancesView;
import com.clustercontrol.cloud.ui.views.actions.MultiSelectionActionEx;
import com.clustercontrol.util.Messages;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

public class StopInstanceAction
extends MultiSelectionActionEx {
    public static final String ID = "com.clustercontrol.cloud.ui.views.actions.StopInstanceAction";
    private MessageManager messages = MessageManager.getInstance("messages");
    private String strFacilityId = this.messages.getString("word.facility_id");
    private String strInstanceId = this.messages.getString("word.instance_id");
    private String msgStopTemplateInstanceConfirm = this.messages.getString("message.stop_template_instance_confirm");
    private String msgStopInstanceConfirm = this.messages.getString("message.confirm_some_action_to_subjects", new Object[]{"word.instance", "word.stop"});
    private String msgStopInstanceResult = this.messages.getString("message.some_command_has_been_accepted", new Object[]{"word.instance", "word.stop"});

    @Override
    protected boolean canEnabled(IStructuredSelection selection) {
        for (ICloudInstance instance : selection) {
            if (instance.getState() != null && ICloudInstance.StateType.running == ICloudInstance.StateType.byLabel(instance.getState())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void invoke(IAction action) {
        IAccountResource.IRegion region = ((InstancesView)this.viewPart).getActiveRegion();
        ICloudTemplateManager templateManager = region.getAccountResource().getCloudTemplateManager();
        ICloudInstance tmpInstance2 = null;
        StringBuffer sb = new StringBuffer();
        String confirmMessage = "";
        StopInstanceDialog.DialogOutput output = null;
        if (((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).size() > 1) {
            Iterator iter = ((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).iterator();
            int i = 0;
            while (iter.hasNext()) {
                ICloudInstance instance = (ICloudInstance)iter.next();
                sb.append(this.strFacilityId + " = " + instance.getFacilityId() + ", " + this.strInstanceId + " = " + instance.getInstanceId());
                if (iter.hasNext()) {
                    sb.append(", ");
                }
                if (++i <= 10) continue;
                sb.append("\n");
                i = 0;
            }
            confirmMessage = this.msgStopTemplateInstanceConfirm + "\n" + sb;
        } else {
            tmpInstance2 = (ICloudInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
            sb.append(this.strFacilityId + " = " + tmpInstance2.getFacilityId() + ", " + this.strInstanceId + " = " + tmpInstance2.getInstanceId());
            StopInstanceDialog dialog = new StopInstanceDialog(this.viewPart.getSite().getShell());
            StopInstanceDialog.DialogInput input = new StopInstanceDialog.DialogInput();
            input.setInstanceId(tmpInstance2.getInstanceId());
            input.setRegion(tmpInstance2.getRegion());
            input.setAccountResourceId(tmpInstance2.getCloudInstanceManager().getRegion().getAccountResource().getAccountResourceId());
            if (tmpInstance2.getTemplateId() != null && !tmpInstance2.getTemplateId().equals("")) {
                input.setTemplateId(tmpInstance2.getTemplateId());
            }
            dialog.setInput(input);
            if (dialog.open() != 0) {
                return;
            }
            output = dialog.getOutput();
            confirmMessage = this.msgStopInstanceConfirm + "\n" + sb;
        }
        if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)confirmMessage)) {
            if (tmpInstance2 == null) {
                for (ICloudInstance tmpInstance2 : (IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()) {
                    if (tmpInstance2.getTemplateId() != null && !tmpInstance2.getTemplateId().equals("")) {
                        CloudTemplate template = templateManager.getCloudTemplate(tmpInstance2.getTemplateId());
                        RunJobRequest request = new RunJobRequest();
                        request.setJobId(template.getStopJobId());
                        request.setRunJobFlg(true);
                        tmpInstance2.stop(request);
                        continue;
                    }
                    tmpInstance2.stop();
                }
            } else {
                RunJobRequest request = new RunJobRequest();
                request.setJobId(output.getJobId());
                request.setRunJobFlg(output.getRunJobFlg());
                request.setArguments(output.getArguments());
                tmpInstance2.stop(request);
            }
            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgStopInstanceResult);
            final Iterator iter2 = ((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).iterator();
            InstancesView view = (InstancesView)this.viewPart;
            view.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    while (iter2.hasNext()) {
                        InstanceMonitorService.getInstanceMonitorService().startMonitor((ICloudInstance)iter2.next(), ICloudInstance.StateType.stopped);
                    }
                }
            });
        }
    }
}

