/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.presenter;

import java.util.List;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.presenter.AccountResource.Region;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;

public class CloudInstanceBackupManager extends InternalContainer<CloudInstanceBackup, com.clustercontrol.ws.cloud.CloudInstanceBackup> implements ICloudInstanceBackupManager {
	private Region region;
	private CloudComputeService cloudComputeService;
	
	public CloudInstanceBackupManager(CloudComputeService cloudComputeService) {
		this.cloudComputeService = cloudComputeService;
		this.region = cloudComputeService.getRegion();
	}
	
	@Override
	public Region getRegion() {
		return region;
	}

	public CloudInstanceBackup getCloudInstanceBackup(String cloudInstanceBackupId){
		for(CloudInstanceBackup cloudInstanceBackup: getComponents()){
			if(cloudInstanceBackup.getInstanceBackupId().equals(cloudInstanceBackupId)){
				return cloudInstanceBackup;
			}
		}
		return null;
	}
	
	@Override
	public CloudInstanceBackup[] getCloudInstanceBackups() {
		return getComponents().toArray(new CloudInstanceBackup[0]);
	}

	@Override
	public CloudInstanceBackup backupCloudInstance(CreateInstanceBackupRequest createInstanceBackupRequest) {
		com.clustercontrol.ws.cloud.CreateInstanceBackupRequest wsCreateCloudInstanceBackupRequest = new com.clustercontrol.ws.cloud.CreateInstanceBackupRequest();
		ControlUtil.exportObject(createInstanceBackupRequest, wsCreateCloudInstanceBackupRequest);
		try {
			com.clustercontrol.ws.cloud.CloudInstanceBackup reWsCloudInstanceBackup = getEndpoint().addInstanceBackup(getRoleId(), region.getRegion(), wsCreateCloudInstanceBackupRequest);
			CloudInstanceBackup cloudInstanceBackup = CloudInstanceBackup.createCloudInstanceBackup(this, reWsCloudInstanceBackup);
			getComponents().add(cloudInstanceBackup);
			fireComponentAdded(cloudInstanceBackup);
			return cloudInstanceBackup;
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
	}

	@Override
	public void removeCloudInstanceBackup(String instanceBackupId) {
		try {
			getEndpoint().removeInstanceBackup(getRoleId(), getRegion().getRegion(), instanceBackupId);
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
		CloudInstanceBackup cloudInstanceBackup = getCloudInstanceBackup(instanceBackupId);
		getComponents().remove(cloudInstanceBackup);
		fireComponentRemoved(cloudInstanceBackup);
	}

	@Override
	protected List<com.clustercontrol.ws.cloud.CloudInstanceBackup> getSources() throws CloudModelException {
		try {
			return getEndpoint().getInstanceBackupsByRegion(getRoleId(), region.getRegion());
		}
		catch (Exception e) {
			throw new CloudModelException(e);
		}
	}

	@Override
	protected CloudInstanceBackup createComponent(com.clustercontrol.ws.cloud.CloudInstanceBackup source) throws CloudModelException {
		CloudInstanceBackup cloudInstanceBackup = new CloudInstanceBackup(this);
		cloudInstanceBackup.overwrite(source);
		return cloudInstanceBackup;
	}

	@Override
	protected void fireComponentAdded(CloudInstanceBackup addedValue) {
		fireElementAdded(p2.cloudInstanceBackups, addedValue);
	}

	@Override
	protected void fireComponentRemoved(CloudInstanceBackup removedValue) {
		fireElementRemoved(p2.cloudInstanceBackups, removedValue);
	}
	
	private CloudEndpoint getEndpoint(){
		return getRegion().getAccountResource().getAccountResourceManager().getCloudResourceManager().getEndpoint(CloudEndpoint.class);
	}
	
	private String getRoleId(){
		return getRegion().getAccountResource().getActiveUser().getRoleId();
	}

	@Override
	public ICloudComputeService getCloudComputeService() {
		return cloudComputeService;
	}
}
