/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.cloud.plugin.decorator.ARDecoratorProvider;

//import com.clustercontrol.cloud.aws.presenter.CloudModelException;
//import java.util.Map;



public class CloudResourceManager extends Element implements ICloudResourceManager {
//	private MessageManager bundle_messages = MessageManager.getInstance("messages");
	
	private IEndpointManager endpointManager;

	//	private IdentityManagement identityManagement;
	private HinemosService hinemosService;
//	private Inventory invntory;
//	private Map<String, Inventory> inventories;

	private CloudServiceManager cloudServiceManager;
	private AccountResourceManager accountResourceManager;
	
	private ARDecoratorProvider aRDecoratorProvider;
	
	public CloudResourceManager(IEndpointManager endpointManager) {
		assert endpointManager != null;
		this.endpointManager = endpointManager;
	}
	
	@Override
	public CloudServiceManager getCloudServiceManager(){
		if (cloudServiceManager == null){
			cloudServiceManager = new CloudServiceManager(this);
		}
		return cloudServiceManager;
	}

	@Override
	public AccountResourceManager getAccountResourceManager(){
		if (accountResourceManager == null){
			accountResourceManager = new AccountResourceManager(this);
		}
		return accountResourceManager;
	}

	@Override
	public ARDecoratorProvider getARDecoratorProvider(){
		if (aRDecoratorProvider == null){
			aRDecoratorProvider = new ARDecoratorProvider(this);
		}
		return aRDecoratorProvider;
	}

//	@Override
//	public IdentityManagement getIdentityManagement() {
//		if (identityManagement == null) {
//			identityManagement = new IdentityManagement(this);
//		}
//		return identityManagement;
//	}

	@Override
	public HinemosService getHinemosService() {
		if (hinemosService == null) {
			hinemosService = new HinemosService(this);
		}
		return hinemosService;
	}

	public <T> T getEndpoint(Class<T> clazz) {
		return endpointManager.getEndpoint(clazz);
	}

	@Override
	public String getAccountName() {
		return endpointManager.getAccountName();
	}

//	@Override
//	public IInventory getInventory() throws CloudModelException {
//		if (this.invntory == null) {
//			Inventory iv = new Inventory(this);
//			
//			IIdentity credential = iv.getCredential();
//			if (credential == null) {
//				throw new CloudModelException(bundle_messages.getString("message.not_found_specified_user"), ErrorCodeConstants.IDENTITYMANAGEMENT_INVALID_CLOUDUSER_NOT_FOUND);
//			}
//			
//			this.invntory = iv;
//		}
//		return this.invntory;
//	}

//	@Override
//	public IInventory getInventory(String accountResourceId) throws CloudModelException {
//		if (this.inventories == null) {
//			inventories = new HashMap<String, Inventory>();
//		}
//		if(!inventories.containsKey(accountResourceId)){
//			Inventory inventory = new Inventory(this, accountResourceId);
//			
//			if (inventory.getRoleId() == null || inventory.getRoleId().isEmpty()) {
//				//TODO
//				throw new CloudModelException(bundle_messages.getString("message.not_found_specified_user"), ErrorCodeConstants.IDENTITYMANAGEMENT_INVALID_CLOUDUSER_NOT_FOUND);
//			}
//			
//			this.inventories.put(accountResourceId, inventory);
//		}
//		return this.inventories.get(accountResourceId);
//	}
}