/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.annotation.Import;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;

public class CloudUser extends InternalComponent<CloudUserManager, com.clustercontrol.ws.cloud.CloudUser> implements ICloudUser {
	private String cloudUserId;
	private String cloudUserName;
	private String description;
	private String accountResourceId;
	private String cloudUserType;
	private String roleId;
	private String accessKey;
	private String secretKey;
	private Long regDate;
	private String regUser;
	private Long updateDate;
	private String updateUser;

	private CloudUserManager cloudUserManager;

	public CloudUser(CloudUserManager container) {
		super(container);
		this.cloudUserManager = container;
	}

	@Override
	public String getCloudUserId() {
		return cloudUserId;
	}

	@Override
	public String getCloudUserName() {
		return cloudUserName;
	}

	@Override
	public String getDescription() {
		return description;
	}

	@Override
	public String getAccountResourceId() {
		return accountResourceId;
	}

	@Override
	public String getCloudUserType() {
		return cloudUserType;
	}

	@Override
	public String getRoleId() {
		return roleId;
	}

	@Override
	public String getAccessKey() {
		return accessKey;
	}

	@Override
	public String getSecretKey() {
		return secretKey;
	}

	@Override
	public Long getRegDate() {
		return regDate;
	}

	@Override
	public String getRegUser() {
		return regUser;
	}

	@Override
	public Long getUpdateDate() {
		return updateDate;
	}

	@Override
	public String getUpdateUser() {
		return updateUser;
	}

	@Override
	public CloudUserManager getCloudUserManager() {
		return cloudUserManager;
	}

	@Import
	public void setCloudUserId(String cloudUserId) {
		internalSet("cloudUserId", p2.cloudUserId, cloudUserId);
	}

	@Import
	public void setCloudUserName(String cloudUserName) {
		internalSet("cloudUserName", p2.cloudUserName, cloudUserName);
	}

	@Import
	public void setDescription(String description) {
		internalSet("description", p2.description, description);
	}

	@Import
	public void setAccountResourceId(String accountResourceId) {
		internalSet("accountResourceId", p2.accountResourceId, accountResourceId);
	}

	public void setCloudUserType(String cloudUserType) {
		internalSet("cloudUserType", p2.cloudUserType, cloudUserType);
	}

	@Import
	public void setRoleId(String roleId) {
		internalSet("roleId", p2.roleId, roleId);
	}

	@Import
	public void setRegDate(Long regDate) {
		internalSet("regDate", p2.regDate, regDate);
	}

	@Import
	public void setRegUser(String regUser) {
		internalSet("regUser", p2.regUser, regUser);
	}

	@Import
	public void setUpdateDate(Long updateDate) {
		internalSet("updateDate", p2.updateDate, updateDate);
	}

	@Import
	public void setUpdateUser(String updateUser) {
		internalSet("updateUser", p2.updateUser, updateUser);
	}

	@Import
	public void setAccessKey(String accessKey) {
		internalSet("accessKey", p2.accessKey, accessKey);
	}

	@Import
	public void setSecretKey(String secretKey) {
		internalSet("secretKey", p2.secretKey, secretKey);
	}

	@Override
	public boolean equalValues(com.clustercontrol.ws.cloud.CloudUser source) {
		return getCloudUserId().equals(source.getCloudUserId());
	}

	@Override
	public com.clustercontrol.ws.cloud.CloudUser getSource() throws CloudModelException {
		try {
			return getCloudUserManager().getAccountResource().getAccountResourceManager().getCloudResourceManager().getEndpoint(CloudEndpoint.class).getCloudUser(cloudUserId);
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
	}

	@Override
	protected void overwrite(com.clustercontrol.ws.cloud.CloudUser source) {
		ControlUtil.importObject(this, source);
		setCloudUserType(source.getCloudUserType().name());
	}

	@Override
	public CloudUser modifyCloudUser(ModifyCloudUserRequest modifyCloudUserRequest) {
		com.clustercontrol.ws.cloud.ModifyCloudUserRequest wsModifyCloudUserRequest = new com.clustercontrol.ws.cloud.ModifyCloudUserRequest();
		ControlUtil.exportObject(modifyCloudUserRequest, wsModifyCloudUserRequest);
		try {
			com.clustercontrol.ws.cloud.CloudUser reWsCloudUser = getCloudUserManager().getAccountResource().getAccountResourceManager().getCloudResourceManager().getEndpoint(CloudEndpoint.class).modifyCloudUser(wsModifyCloudUserRequest);
			overwrite(reWsCloudUser);
			return this;
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
	}

}
