/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.presenter;



/**
 * 全ての要素の基底定義。
 * 
 * @author torun
 *
 */
public interface IElement {
	/**
	 * イベントリスナーの追加。
	 * 
	 * @param <L>
	 * @param type
	 * @param listener
	 */
	<L extends EventListener> void addEventListener(Type<L> type, L listener);

	/**
	 * イベントリスナーの削除。
	 * 
	 * @param <L>
	 * @param type
	 * @param listener
	 */
	<L extends EventListener> void removeEventListener(Type<L> type, L listener);

	/**
	 * プロパティオブザーバーの追加。
	 * 
	 * @param <P>
	 * @param <O>
	 * @param pid
	 * @param observer
	 */
	<P, O extends PropertyObserver2<P>> void addPropertyObserver2(PropertyId2<O> pid, O observer);

	/**
	 * プロパティオブザーバーの削除。
	 * 
	 * @param <P>
	 * @param <O>
	 * @param pid
	 * @param observer
	 */
	<P, O extends PropertyObserver2<P>> void removePropertyObserver2(PropertyId2<O> pid, O observer);
	
	/**
	 * 全てのシンプルプロパティの変更が対象となる識別子。 
	 */
	static final PropertyId2<AllPropertyObserver> allProperty = PropChangedEventNotifier.allProperty;
	
	/**
	 * 要素の更新タイミングを観測するオブジェクトの定義。<br>
	 * addEventListener で観測対象の要素へ追加する。
	 * 
	 * @author torun
	 *
	 */
	interface ElementListerner extends EventListener {
		/**
		 * 要素が更新されたタイミングで呼び出されます。
		 * 
		 * @param event
		 */
		void elementUpdated(UpdateEvent event);
	}

	/**
	 * 要素の更新時に発生するイベント。
	 * 
	 * @author torun
	 *
	 */
	static class UpdateEvent extends Event<IElement, ElementListerner> {
		private static Type<ElementListerner> TYPE = new Type<ElementListerner>(){};

		public UpdateEvent(IElement source) {
			super(source);
		}
		public void dispatch(ElementListerner listener) {
			listener.elementUpdated(this);
		}
		public Type<ElementListerner> getAssociatedType() {
			return getType();
		}
		public static Type<ElementListerner> getType() {
			return TYPE;
		}
	}
	
	/**
	 * 内部の情報を最新にする。
	 */
	void update() throws CloudModelException;
}
