/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.commons.util.AccountControlUtil;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.ValidateException;
import com.clustercontrol.cloud.commons.util.annotation.RequiredInput;
import com.clustercontrol.cloud.commons.util.annotation.RequiredSelect;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.IAccountResourceManager;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.cloud.AvailableRole;

public class CreateCloudUserDialog extends Dialog {
	
	public interface IDialogBehavior{
		void setupAccountResourceId(Combo cmbAccountResourceId);
		void setupCloudUserId(Text txtCloudUserId);
		void setupCloudUserName(Text txtCloudUserName);
		void setupDescription(Text txtDescription);
//		void setupAccountId(Text txtAccountId);
		void setupAccessKey(Text txtAccessKey);
		void setupSecretKey(Text txtSecretKey);
		void setupAssignRoleId(Combo cmbAssingRoleId);
	}
	
	public static class DialogBehavior implements IDialogBehavior{
		private IAccountResourceManager accountResourceManager = Activator.getDefault().getCloudResourceManager().getAccountResourceManager();
		@Override
		public void setupAccountResourceId(Combo cmbAccountResourceId) {
			for(IAccountResource accountResource: accountResourceManager.getAccountResources()){
				cmbAccountResourceId.add(accountResource.getAccountResourceId());
			}
			if(cmbAccountResourceId.getItemCount() > 0){
				cmbAccountResourceId.select(0);
			}
		}
		@Override
		public void setupCloudUserId(Text txtCloudUserId) {}
		@Override
		public void setupCloudUserName(Text txtCloudUserName) {}
		@Override
		public void setupDescription(Text txtCloudUserDescription) {}
		@Override
		public void setupAccessKey(Text txtAccessKey) {}
		@Override
		public void setupSecretKey(Text txtSecretKey) {}
		@Override
		public void setupAssignRoleId(Combo cmbAssignRoleId) {
			for(AvailableRole role: AccountControlUtil.getAssignableRoles()){
				String roleLabel = role.getRoleName() + "(" + role.getRoleId() + ")"; 
				cmbAssignRoleId.add(roleLabel);
				cmbAssignRoleId.setData(roleLabel, role.getRoleId());
			}
			if(cmbAssignRoleId.getItemCount() > 0){
				cmbAssignRoleId.select(0);
			}
		}
	}
	
	public static class DialogOutput{
		private String accountResourceId;
		private String cloudUserId;
		private String cloudUserName;
		private String description;
		private String accessKey;
		private String secretKey;
		private String roleId;
		public String getAccountResourceId() {
			return accountResourceId;
		}
		public void setAccountResourceId(String accountResourceId) {
			this.accountResourceId = accountResourceId;
		}
		public String getCloudUserId() {
			return cloudUserId;
		}
		public void setCloudUserId(String cloudUserId) {
			this.cloudUserId = cloudUserId;
		}
		public String getCloudUserName() {
			return cloudUserName;
		}
		public void setCloudUserName(String cloudUserName) {
			this.cloudUserName = cloudUserName;
		}
		public String getAccessKey() {
			return accessKey;
		}
		public void setAccessKey(String accessKey) {
			this.accessKey = accessKey;
		}
		public String getSecretKey() {
			return secretKey;
		}
		public void setSecretKey(String secretKey) {
			this.secretKey = secretKey;
		}
		public String getRoleId() {
			return roleId;
		}
		public void setRoleId(String roleId) {
			this.roleId = roleId;
		}
		public String getDescription() {
			return description;
		}
		public void setDescription(String description) {
			this.description = description;
		}
	}
	
	private DialogOutput output = new DialogOutput();
	
	private MessageManager bundle_messages = MessageManager.getInstance("messages");

//	private Shell shell;
	
	private String strSeparator = bundle_messages.getString("caption.title_separator");
	private String strAccountResourceId = bundle_messages.getString("word.account_resource_id");
	private String strCloudUserId = bundle_messages.getString("word.cloud_user_id");
	private String strCloudUserName = bundle_messages.getString("word.cloud_user_name");
	private String strDescription = bundle_messages.getString("word.description");
	private String strAccessKey = bundle_messages.getString("word.access_key");
	private String strSecretKey = bundle_messages.getString("word.secret_key");
	private String strAssignRoleId = bundle_messages.getString("word.assign_role_id");
	private String strAccountResource = bundle_messages.getString("word.account_resource");
//	private String strCloudService = bundle_messages.getString("word.cloud_service");
	private String strCloudUser = bundle_messages.getString("word.cloud_user");
//	private String strCreateRole = bundle_messages.getString("word.create");

	@RequiredSelect("strAccountResourceId")
	private Combo cmbAccountResourceId;
	@RequiredInput("strCloudUserId")
	private Text txtCloudUserId;
	@RequiredInput("strCloudUserName")
	private Text txtCloudUserName;
	private Text txtDescription;
	@RequiredInput("strAccessKey")
	private Text txtAccessKey;
	@RequiredInput("strSecretKey")
	private Text txtSecretKey;
	@RequiredSelect("strAssignRoleId")
	private Combo cmbAssignRoleId;
	

	private IDialogBehavior behavior = new DialogBehavior();

	
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public CreateCloudUserDialog(Shell parentShell) {
		super(parentShell);
//		this.shell = parentShell;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.FILL);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(1, false);
		gl_container.verticalSpacing = 15;
		container.setLayout(gl_container);
		GridData gd_container = new GridData(SWT.FILL, SWT.FILL, true, false);
		gd_container.verticalAlignment = SWT.FILL;
		gd_container.horizontalAlignment = SWT.FILL;
		container.setLayoutData(gd_container);
		
		Group grpAccountResource = new Group(container, SWT.NONE);
		GridLayout gl_accountResource = new GridLayout(2, false);
		gl_accountResource.verticalSpacing = 15;
		grpAccountResource.setLayout(gl_accountResource);
		grpAccountResource.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
		grpAccountResource.setText(strAccountResource);
		
		Label lblAccountResourceId = new Label(grpAccountResource, SWT.RIGHT);
		lblAccountResourceId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblAccountResourceId.setText(strAccountResourceId + strSeparator);

		cmbAccountResourceId = new Combo(grpAccountResource, SWT.READ_ONLY);
		cmbAccountResourceId.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
			
//		{
//			Group grpCloudService = new Group(container, SWT.NONE);
//			GridLayout gl_cloudService = new GridLayout(2, false);
//			gl_cloudService.verticalSpacing = 15;
//			grpCloudService.setLayout(gl_cloudService);
//			GridData gd_cloudService = new GridData(SWT.FILL, SWT.FILL, true, false);
//			grpCloudService.setLayoutData(gd_cloudService);
//			grpCloudService.setText(strCloudService);
//	
//			Label lblCloudServiceId = new Label(grpCloudService, SWT.RIGHT);
//			lblCloudServiceId.setText(strCloudServiceId + strSeparator);
//	
//			cmbCloudServiceId = new Combo(grpCloudService, SWT.READ_ONLY);
//			GridData gd_cloudServiceId = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
//			gd_cloudServiceId.widthHint = 100;
//			cmbCloudServiceId.setLayoutData(gd_cloudServiceId);
//		}

		Group grpCloudUser = new Group(container, SWT.NONE);
		GridLayout gl_cloudUser = new GridLayout(2, false);
		gl_cloudUser.verticalSpacing = 15;
		grpCloudUser.setLayout(gl_cloudUser);
		grpCloudUser.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
		grpCloudUser.setText(strCloudUser);

		Label lblCloudUserId = new Label(grpCloudUser, SWT.RIGHT);
		lblCloudUserId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblCloudUserId.setText(strCloudUserId + strSeparator);

		txtCloudUserId = new Text(grpCloudUser, SWT.BORDER);
		txtCloudUserId.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		Label lblCloudUserName = new Label(grpCloudUser, SWT.RIGHT);
		lblCloudUserName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblCloudUserName.setText(strCloudUserName + strSeparator);

		txtCloudUserName = new Text(grpCloudUser, SWT.BORDER);
		txtCloudUserName.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));

		Label lblDescription = new Label(grpCloudUser, SWT.RIGHT);
		lblDescription.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblDescription.setText(strDescription + strSeparator);

		txtDescription = new Text(grpCloudUser, SWT.BORDER);
		txtDescription.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));

		Label lblAccessKey = new Label(grpCloudUser, SWT.RIGHT);
		lblAccessKey.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblAccessKey.setText(strAccessKey + strSeparator);

		txtAccessKey = new Text(grpCloudUser, SWT.BORDER);
		txtAccessKey.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));

		Label lblSecretKey = new Label(grpCloudUser, SWT.RIGHT);
		lblSecretKey.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblSecretKey.setText(strSecretKey + strSeparator);

		txtSecretKey = new Text(grpCloudUser, SWT.BORDER | SWT.PASSWORD);
		txtSecretKey.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		Label lblOwnerId = new Label(grpCloudUser, SWT.RIGHT);
		lblOwnerId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblOwnerId.setText(strAssignRoleId + strSeparator);

		Composite cmpOwnerId = new Composite(grpCloudUser, SWT.NONE);
//			GridLayout gl_cmpOwnerId = new GridLayout(2, false);
		GridLayout gl_cmpOwnerId = new GridLayout(1, false);
		gl_cmpOwnerId.marginWidth = 0;
		cmpOwnerId.setLayout(gl_cmpOwnerId);
		cmpOwnerId.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
		
		cmbAssignRoleId = new Combo(cmpOwnerId, SWT.READ_ONLY);
		GridData gd_ownerId = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_ownerId.widthHint = 100;
		cmbAssignRoleId.setLayoutData(gd_ownerId);
		
//			Button btnCreateOwnerRoll = new Button(cmpOwnerId, SWT.NONE);
//			btnCreateOwnerRoll.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, true, 1, 1));
//			btnCreateOwnerRoll.setText(strCreateRole);
//			btnCreateOwnerRoll.addSelectionListener(new SelectionAdapter(){
//				@Override
//				public void widgetSelected(SelectionEvent e) {
//					// ダイアログを生成
//					RoleDialog dialog = new RoleDialog(CreateAccountResourceDialog.this.shell, null, false);
//
//					if (dialog.open() == IDialogConstants.OK_ID) {
//						cmbAssignRoleId.removeAll();
//
//						//ロール情報取得
//						List<RoleInfo> infoList = null;
//						try {
//							infoList = AccessEndpointWrapper.getRoleInfoList();
//						} catch (InvalidRole_Exception e1) {
//							// 権限なし
//							MessageDialog.openInformation(null, Messages.getString("message"),
//									Messages.getString("message.accesscontrol.16"));
//
//							// 一覧の参照権限がない場合、ユーザ自身の情報を表示する
//							infoList = new ArrayList<RoleInfo>();
//
//						} catch (Exception e1) {
//							// 上記以外の例外
//							System.out.println(e1.getMessage());
//							MessageDialog.openError(
//									null,
//									Messages.getString("failed"),
//									Messages.getString("message.hinemos.failure.unexpected") + ", " + e1.getMessage());
//						}
//						if(infoList != null && !infoList.isEmpty()){
//							for(RoleInfo info: infoList){
//								cmbAssignRoleId.add(info.getId());
//							}
//							if(cmbAssignRoleId.getItemCount() > 0){
//								cmbAssignRoleId.select(0);
//							}
//						}
//					}
//				}
//			});
		
		//初期化ブロック
		{
			
		}
		
		{
			behavior.setupAccountResourceId(cmbAccountResourceId);
			behavior.setupCloudUserId(txtCloudUserId);
			behavior.setupCloudUserName(txtCloudUserName);
			behavior.setupDescription(txtDescription);
			behavior.setupAccessKey(txtAccessKey);
			behavior.setupSecretKey(txtSecretKey);
			behavior.setupAssignRoleId(cmbAssignRoleId);
		}

		ControlUtil.setRequired(new Control[]{
			txtCloudUserId,
			txtCloudUserName,
			txtAccessKey,
			txtSecretKey
		});

		container.layout();
		Control[] labels = new Control[]{lblAccountResourceId, lblDescription, lblCloudUserId, lblCloudUserName, lblAccessKey, lblSecretKey, lblOwnerId};
		int maxWidth = 0;
		for (Control l: labels) {
			Point p = l.getSize();
			maxWidth = Math.max(maxWidth, p.x);
		}
		for (Control l: labels) {
			((GridData)l.getLayoutData()).widthHint = maxWidth;
		}
		grpAccountResource.layout(true);
		grpCloudUser.layout(true);
		
		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 480);
	}

	@Override
	protected void okPressed() {
		try{
			ControlUtil.validate(this);
		} catch(ValidateException e){
			MessageDialog.openError(null, Messages.getString("failed"), e.getMessage());
			return;
		} catch(Exception e){
			throw new RuntimeException(e);
		}
		
		{
			output.setAccountResourceId(cmbAccountResourceId.getText());
			output.setCloudUserId(txtCloudUserId.getText());
			output.setCloudUserName(txtCloudUserName.getText());
			output.setDescription(txtDescription.getText());
			output.setAccessKey(txtAccessKey.getText());
			output.setSecretKey(txtSecretKey.getText());
			output.setRoleId((String)cmbAssignRoleId.getData(cmbAssignRoleId.getText()));
		}

		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(bundle_messages.getString("caption.create_cloud_user_dialog"));
	}

	public DialogOutput getOutput() {
		return output;
	}

	public void setBehavior(IDialogBehavior behavior){
		this.behavior = behavior;
	}
}
