/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.window.Window;

import com.clustercontrol.cloud.commons.util.AccountControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TemplateJobUtil;
import com.clustercontrol.cloud.ui.dialogs.CreateTemplateJobDialog;
import com.clustercontrol.cloud.ui.views.TemplatesView;
import com.clustercontrol.util.Messages;


public class CreateTemplateJobAction extends AbstractViewAction {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.CreateTemplateJobAction";

	private MessageManager messages = MessageManager.getInstance("messages");
	
	private String msgCreateTemplateJobConfirm = messages.getString("message.confirm_some_action_to_something", new Object[]{"word.template_job", "word.create"});
	private String msgCreateTemplateJobResult = messages.getString("message.result_some_action_to_something", new Object[]{"word.template_job", "word.create"});

	@Override
	protected void invoke(IAction action) throws InvocationException {
		CreateTemplateJobDialog dialog = new CreateTemplateJobDialog(this.viewPart.getSite().getShell());
		dialog.setRoleId(
			AccountControlUtil.getRoleId(((TemplatesView)viewPart).getAccountResource().getAccountResourceId())
		);
			
		if (dialog.open() == Window.OK) {
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgCreateTemplateJobConfirm)) {

				try {
					CreateTemplateJobDialog.DialogOutput output = dialog.getOutput();
					
					TemplateJobUtil.TemplateJobnet jobnet = new TemplateJobUtil.TemplateJobnet();
					
					jobnet.setJobnetId(output.getJobnetId());
					jobnet.setJobnetName(output.getJobnetName());
					jobnet.setOsType(output.getOsType());
					jobnet.setJobs(output.getTemplateJobList());
					
					TemplateJobUtil.registerJob(((TemplatesView)viewPart).getAccountResource().getAccountResourceId(), jobnet);
					
				} catch (Exception e) {
					throw new InvocationException(e);
				}
				
				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgCreateTemplateJobResult);
			}
			else {
				return;
			}
		}
	}
	
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		if(((TemplatesView)viewPart).getAccountResource() != null){
			action.setEnabled(true);
		} else {
			action.setEnabled(false);
		}
	}
}