/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;


import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.IAccountResourceManager;
import com.clustercontrol.util.Messages;


public class RemoveAccountResourceAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.RemoveAccountResourceAction";

	private MessageManager messages = MessageManager.getInstance("messages");
	
	private String msgRemoveAccountResourceConfirm = messages.getString("message.confirm_some_action_to_something", new Object[]{"word.account_resource", "word.remove"});
	private String msgRemoveAccountResourceResult = messages.getString("message.result_some_action_to_something", new Object[]{"word.account_resource", "word.remove"});

	@Override
	protected void invoke(IAction action) throws InvocationException {
		IStructuredSelection selection = (IStructuredSelection) this.viewPart.getSite().getSelectionProvider().getSelection();
		final IAccountResource accountResource = (IAccountResource)selection.getFirstElement();

		if (MessageDialog.openConfirm(
			null,
			Messages.getString("confirmed"),
			msgRemoveAccountResourceConfirm)) {
			
			IAccountResourceManager manager = Activator.getDefault().getCloudResourceManager().getAccountResourceManager();
			manager.removeAccountResource(accountResource.getAccountResourceId());
			
			com.clustercontrol.action.FacilityTree.refresh();

			// 成功報告ダイアログを生成
			MessageDialog.openInformation(
				null,
				Messages.getString("successful"),
				msgRemoveAccountResourceResult + "\n" + String.format(messages.getString("message.notify_to_delete_remains_related_to_accountresurce"),
						accountResource.getAccountResourceId(), accountResource.getAccountResourceId(), accountResource.getAccountResourceId())
				);
		}
		else {
			return;
		}
	}
}