/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.ICloudOption;
import com.clustercontrol.cloud.IMessagesHolder;
import com.clustercontrol.cloud.MessagesHolder;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.bean.CloudAccountResource;
import com.clustercontrol.cloud.bean.CloudService;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.bean.CreateAccountResourceRequest;
import com.clustercontrol.cloud.bean.CreateCloudUserRequest;
import com.clustercontrol.cloud.bean.ModifyAccountBillingDetailRequest;
import com.clustercontrol.cloud.bean.ModifyAccountResourceRequest;
import com.clustercontrol.cloud.dao.CloudAccountResourceDao;
import com.clustercontrol.cloud.dao.CloudUserDao;
import com.clustercontrol.cloud.factory.IAccountResourceOperator;
import com.clustercontrol.cloud.factory.ICloudServiceOperator;
import com.clustercontrol.cloud.factory.ICloudUserOperator;
import com.clustercontrol.cloud.factory.RemovedEventNotifier;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.persistence.IDHolder;
import com.clustercontrol.cloud.persistence.Transactional;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.cloud.util.AccountResourceUtil;
import com.clustercontrol.cloud.util.CloudCredential;
import com.clustercontrol.cloud.util.RepositoryControllerBeanWrapper;
import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.repository.session.RepositoryControllerBean;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityExistsException;
import javax.persistence.NoResultException;
import javax.persistence.Query;

@Transactional
public class AccountResourceOperator
implements IAccountResourceOperator {
    @Override
    public CloudAccountResource createCloudAccountResource(CreateAccountResourceRequest request) throws CloudManagerFault, InvalidRole {
        CloudAccountResourceDao dao = new CloudAccountResourceDao();
        dao.setAccountResourceId(request.getAccountResourceId());
        dao.setAccountResourceName(request.getAccountResourceName());
        dao.setCloudServiceId(request.getCloudServiceId());
        dao.setDescription(request.getDescription());
        dao.setRetentionPeriod(31);
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        try {
            em.persist((IDHolder)dao);
        }
        catch (EntityExistsException e) {
            throw ErrorCode.ACCOUNTRESOURCE_ALREADY_EXIST.cloudManagerFault(dao.getAccountResourceId());
        }
        ICloudServiceOperator serviceOperator = (ICloudServiceOperator)ObjectRegistryService.registry().get(ICloudServiceOperator.class);
        CloudService service = serviceOperator.findCloudService(request.getCloudServiceId());
        AccountResourceUtil.buildAccountResourceHierarchy((RepositoryControllerBean)RepositoryControllerBeanWrapper.bean(), dao.getAccountResourceId(), dao.getAccountResourceName(), service.getCloudTypeId(), dao.getDescription(), dao.getCloudServiceId(), request.getAccount().getRoleId(), (IMessagesHolder)new MessagesHolder("com.clustercontrol.cloud.messages"));
        CreateCloudUserRequest userRequest = new CreateCloudUserRequest();
        userRequest.setCloudUserId(request.getAccount().getCloudUserId());
        userRequest.setCloudUserName(request.getAccount().getCloudUserName());
        userRequest.setAccountResourceId(dao.getAccountResourceId());
        userRequest.setAccessKey(request.getAccount().getAccessKey());
        userRequest.setSecretKey(request.getAccount().getSecretKey());
        userRequest.setDescription(request.getAccount().getDescription());
        userRequest.setRoleId(request.getAccount().getRoleId());
        ICloudUserOperator userOperator = (ICloudUserOperator)ObjectRegistryService.registry().get(ICloudUserOperator.class);
        userOperator.createCloudAccount(userRequest);
        CloudUserDao userDao = (CloudUserDao)em.find(CloudUserDao.class, (Object)userRequest.getCloudUserId());
        assert (userDao != null);
        Query query = em.createQuery("UPDATE CloudAccountResourceDao a SET a.account = :user WHERE a.accountResourceId = '" + request.getAccountResourceId() + "'");
        query.setParameter("user", (Object)userDao);
        query.executeUpdate();
        return new CloudAccountResource(dao);
    }

    @Override
    public CloudAccountResource modifyCloudAccountResource(ModifyAccountResourceRequest request) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudAccountResourceDao dao = (CloudAccountResourceDao)em.find(CloudAccountResourceDao.class, (Object)request.getAccountResourceId());
        if (dao == null) {
            throw ErrorCode.ACCOUNTRESOURCE_INVALID_ACCOUNTRESOURCE_NOT_FOUND.cloudManagerFault(request.getAccountResourceId());
        }
        if (request.getAccountResourceName() != null) {
            dao.setAccountResourceName(request.getAccountResourceName());
        }
        if (request.getDescription() != null) {
            dao.setDescription(request.getDescription());
        }
        return new CloudAccountResource(dao);
    }

    @Override
    public CloudAccountResource modifyAccountBillingDetail(ModifyAccountBillingDetailRequest request) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudAccountResourceDao dao = (CloudAccountResourceDao)em.find(CloudAccountResourceDao.class, (Object)request.getAccountResourceId());
        if (dao == null) {
            throw ErrorCode.ACCOUNTRESOURCE_INVALID_ACCOUNTRESOURCE_NOT_FOUND.cloudManagerFault(request.getAccountResourceId());
        }
        dao.setBillingDetailCollectorFlg(request.isBillingDetailCollectorFlg().booleanValue());
        dao.setRetentionPeriod(request.getRetentionPeriod().intValue());
        return new CloudAccountResource(dao);
    }

    @Override
    public void removeCloudAccountResource(String accountResourceId) throws CloudManagerFault, InvalidRole {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudAccountResourceDao dao = (CloudAccountResourceDao)em.find(CloudAccountResourceDao.class, (Object)accountResourceId);
        if (dao == null) {
            throw ErrorCode.ACCOUNTRESOURCE_INVALID_ACCOUNTRESOURCE_NOT_FOUND.cloudManagerFault(accountResourceId);
        }
        try (RemovedEventNotifier<CloudAccountResource> notifier = new RemovedEventNotifier<CloudAccountResource>("Node_AccountResource", CloudAccountResource.class, new CloudAccountResource(dao));){
            em.remove((Object)dao);
            AccountResourceUtil.removeAccountResourceHierarchy((RepositoryControllerBean)RepositoryControllerBeanWrapper.bean(), accountResourceId);
            notifier.setCompleted();
        }
    }

    @Override
    @Transactional(value=Transactional.TransactionType.Supported)
    public CloudAccountResource findCloudAccountResource(String accountResourceId) throws CloudManagerFault {
        try {
            EntityManagerEx em = SessionService.current().getEntityManagerEx();
            return new CloudAccountResource((CloudAccountResourceDao)em.find(CloudAccountResourceDao.class, (Object)accountResourceId));
        }
        catch (NoResultException e) {
            throw ErrorCode.ACCOUNTRESOURCE_INVALID_ACCOUNTRESOURCE_NOT_FOUND.cloudManagerFault(accountResourceId);
        }
    }

    @Override
    @Transactional(value=Transactional.TransactionType.Supported)
    public CloudAccountResource findCloudAccountResourceByCurrentUser(String accountResourceId) throws CloudManagerFault {
        return this.findCloudAccountResourceByUser(SessionService.current().getHinemosCredential().getUserId(), accountResourceId);
    }

    @Override
    @Transactional(value=Transactional.TransactionType.Supported)
    public List<CloudAccountResource> findAllCloudAccountResource() throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        ArrayList<CloudAccountResource> cars = new ArrayList<CloudAccountResource>();
        for (CloudAccountResourceDao dao : em.findAll(CloudAccountResourceDao.class)) {
            cars.add(new CloudAccountResource(dao));
        }
        return cars;
    }

    @Override
    @Transactional(value=Transactional.TransactionType.Supported)
    public List<CloudAccountResource> findCloudAccountResourcesByCurrentUser() throws CloudManagerFault {
        return this.findCloudAccountResourcesByUser(SessionService.current().getHinemosCredential().getUserId());
    }

    @Override
    @Transactional(value=Transactional.TransactionType.Supported)
    public List<String> getCloudServicesForBilling(String accountResourceId) throws CloudManagerFault {
        IAccountResourceOperator operator = (IAccountResourceOperator)ObjectRegistryService.registry().get(IAccountResourceOperator.class);
        CloudAccountResource accountResource = operator.findCloudAccountResource(accountResourceId);
        ICloudServiceOperator serviceOperator = (ICloudServiceOperator)ObjectRegistryService.registry().get(ICloudServiceOperator.class);
        CloudService cloudService = serviceOperator.findCloudService(accountResource.getCloudServiceId());
        ICloudUserOperator userOperator = (ICloudUserOperator)ObjectRegistryService.registry().get(ICloudUserOperator.class);
        CloudUser cloudUser = userOperator.findCloudUser(accountResource.getAccountId());
        ICloudOption cloudOption = (ICloudOption)ObjectRegistryService.registry().get(ICloudOption.class, (Object)cloudService.getCloudTypeId());
        cloudOption.setCredential(new CloudCredential(cloudUser));
        return cloudOption.getCloudServicesForBilling();
    }

    @Override
    public CloudAccountResource findCloudAccountResourceByUser(String userId, String accountResourceId) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        Query query = em.createQuery("SELECT DISTINCT u.accountResource FROM CloudUserDao u, UserEntity h, RoleEntity r WHERE (u.accountResource.accountResourceId = :accountResourceId AND h.userId = :userId AND h MEMBER OF r.userEntities AND r.roleId = u.roleId) OR (h.userId = :userId AND h MEMBER OF r.userEntities AND r.roleId = :ADMINISTRATORS)");
        query.setParameter("accountResourceId", (Object)accountResourceId);
        query.setParameter("userId", (Object)SessionService.current().getHinemosCredential().getUserId());
        query.setParameter("ADMINISTRATORS", (Object)"ADMINISTRATORS");
        try {
            return new CloudAccountResource((CloudAccountResourceDao)query.getSingleResult());
        }
        catch (NoResultException e) {
            throw ErrorCode.ACCOUNTRESOURCE_INVALID_ACCOUNTRESOURCE_NOT_FOUND.cloudManagerFault(accountResourceId);
        }
    }

    @Override
    public List<CloudAccountResource> findCloudAccountResourcesByUser(String userId) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        Query query = em.createQuery("SELECT DISTINCT u.accountResource FROM CloudUserDao u, UserEntity h, RoleEntity r WHERE (h.userId = :userId AND h MEMBER OF r.userEntities AND r.roleId = u.roleId) OR (h.userId = :userId AND h MEMBER OF r.userEntities AND r.roleId = :ADMINISTRATORS)");
        query.setParameter("userId", (Object)SessionService.current().getHinemosCredential().getUserId());
        query.setParameter("ADMINISTRATORS", (Object)"ADMINISTRATORS");
        List daos = query.getResultList();
        ArrayList<CloudAccountResource> cars = new ArrayList<CloudAccountResource>();
        for (Object dao : daos) {
            cars.add(new CloudAccountResource((CloudAccountResourceDao)dao));
        }
        return cars;
    }
}

