/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.PluginFault;
import com.clustercontrol.cloud.registry.IObjectChangedService;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.fault.InvalidRole;

public class ModifiedEventNotifier<T>
implements AutoCloseable {
    private String type;
    private Class<T> clazz;
    private T object;
    private boolean completed;

    public ModifiedEventNotifier(String type, Class<T> clazz, T object) throws CloudManagerFault, InvalidRole {
        this.type = type;
        this.clazz = clazz;
        this.object = object;
        try {
            ((IObjectChangedService)ObjectRegistryService.registry().get(IObjectChangedService.class)).firePreModifiedEvent(type, clazz, object);
        }
        catch (CloudManagerFault e) {
            if (e.getCause() instanceof InvalidRole) {
                throw (InvalidRole)e.getCause();
            }
            throw e;
        }
        catch (PluginFault e) {
            throw new CloudManagerFault(e);
        }
    }

    public void setCompleted() {
        this.completed = true;
    }

    @Override
    public void close() throws CloudManagerFault, InvalidRole {
        if (!this.completed) {
            return;
        }
        try {
            ((IObjectChangedService)ObjectRegistryService.registry().get(IObjectChangedService.class)).firePostModifiedEvent(this.type, this.clazz, this.object);
        }
        catch (CloudManagerFault e) {
            if (e.getCause() instanceof InvalidRole) {
                throw (InvalidRole)e.getCause();
            }
            throw e;
        }
        catch (PluginFault e) {
            throw new CloudManagerFault(e);
        }
    }
}

