/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.commons;

import org.apache.log4j.Logger;

import com.clustercontrol.commons.util.HinemosProperties;

public enum CloudPropertyConstants implements PropertyContract {
	billingalarm_servicename("hinemos.cloud.billingalarm.servicename", "Total,AmazonEC2,AmazonS3,AmazonSimpleDB,AmazonSNS,AWSDataTransfer"),
	billingalarm_notify_interval("hinemos.cloud.billing.notify.interval", "0 15 * * * ?"),

	autoupdate_node("hinemos.cloud.autoupdate.node", on, PropValidator.switchValidator),
	autoupdate_mount("hinemos.cloud.autoupdate.mount", on, PropValidator.switchValidator),
	autoupdate_instance("hinemos.cloud.autoupdate.instance", on, PropValidator.switchValidator),			
	autoupdate_storage("hinemos.cloud.autoupdate.storage", on, PropValidator.switchValidator),	// 未使用。
	autoupdate_backup("hinemos.cloud.autoupdate.backup", on, PropValidator.switchValidator),
	autoupdate_interval("hinemos.cloud.autoupdate.interval", "0 */10 * * * ?"),

	internal_thread_admin_user("hinemos.cloud.internal_thread.admin.user", "hinemos"),
	
	autoregist_scope_relation("hinemos.cloud.autoregist.scope.relation", on, PropValidator.switchValidator),
	autoregist_instance("hinemos.cloud.autoregist.instance", on, PropValidator.switchValidator),
	autoregist_storage("hinemos.cloud.autoregist.storage", on, PropValidator.switchValidator),

	password_crypt_key("hinemos.cloud.password.crypt.key", "hinemos"),

	registcheck_interval("hinemos.cloud.registcheck.interval", String.valueOf(10000), PropValidator.intValidator),
	registcheck_count("hinemos.cloud.registcheck.count", String.valueOf(30), PropValidator.intValidator),

	agent_connection_interval("agent.connection.interval", String.valueOf(10000), PropValidator.intValidator),
	agent_connection_count("agent.connection.count", String.valueOf(30), PropValidator.intValidator),
	
	templatejob_endcheck_interval("hinemos.cloud.templatejob.endcheck.interval", String.valueOf(10000), PropValidator.intValidator),
	templatejob_endcheck_count("hinemos.cloud.templatejob.endcheck.count", String.valueOf(30), PropValidator.intValidator),
	
	templatejob_script_file_dir("hinemos.cloud.templatejob.scriptfile.dir", "var/cloud/"),;

//	poller_retry_count("hinemos.cloud.poller.retry.count", String.valueOf(3), PropValidator.intValidator),
//	poller_retry_interval("hinemos.cloud.poller.retry.interval", String.valueOf(100), PropValidator.intValidator);
		
	public final String id;
	public final String value;
	public final PropValidator validator;

	private CloudPropertyConstants(String id, String value) {
		this.id = id;
		this.value = value;
		this.validator = null;
	}

	private CloudPropertyConstants(String id, String value, PropValidator validator) {
		this.id = id;
		this.value = value;
		this.validator = validator;
	}
	
	public String value() {
		String prop = HinemosProperties.getProperty(id, value);
		if (validator != null) {
			try {
				validator.validate(prop);
			}
			catch (Exception e) {
				Logger logger = Logger.getLogger(CloudPropertyConstants.class);
				logger.error(id + " is invalid("+ prop +"), using default value(" + value + ").");
				prop = value;
			}
		}
		return prop;
	}

	public boolean match(String value) {
		return value().equals(value);
	}

	public String defaultValue() {
		return this.value;
	}
}
