/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.dao;

import java.sql.Timestamp;

import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Table;

import com.clustercontrol.cloud.persistence.BooleanTFConverter;

@Entity
@Table(name = "cc_cloud_account_resource")
public class CloudAccountResourceDao extends HinemosObjectDao {
	private String accountResourceId;
	private String accountResourceName;
	private String cloudServiceId;
	private CloudUserDao account;
	private boolean billingDetailCollectorFlg;
	private int retentionPeriod;
	private String description;
	private Timestamp billingLastDate;

	public CloudAccountResourceDao() {
	}
	public CloudAccountResourceDao(String accountResourceId, String accountResourceName, String cloudServiceId, CloudUserDao adminUser, String description, Timestamp billingLastDate, Timestamp regDate, Timestamp updateDate, String regUser, String updateUser) {
		super(regDate, updateDate, regUser, updateUser);
		setAccountResourceId(accountResourceId);
		setAccountResourceName(accountResourceName);
		setCloudServiceId(cloudServiceId);
		setAccount(adminUser);
		setDescription(description);
		setBillingLastDate(billingLastDate);
	}

	public CloudAccountResourceDao(CloudAccountResourceDao otherData)
	{
		super(otherData);
		setAccountResourceId(otherData.getAccountResourceId());
		setAccountResourceName(otherData.getAccountResourceName());
		setCloudServiceId(otherData.getCloudServiceId());
		setAccount(otherData.getAccount());
		setDescription(otherData.getDescription());
		setBillingLastDate(otherData.getBillingLastDate());
	}
	
	@Id
	@Column(name="account_resource_id")
	public String getAccountResourceId() {
		return accountResourceId;
	}
	
	public void setAccountResourceId(String accountResourceId) {
		this.accountResourceId = accountResourceId;
	}

	@Column(name="account_resource_name")
	public String getAccountResourceName() {
		return accountResourceName;
	}
	
	public void setAccountResourceName(String accountResourceName) {
		this.accountResourceName = accountResourceName;
	}
	
	@Column(name="cloud_service_id")
	public String getCloudServiceId() {
		return cloudServiceId;
	}
	
	public void setCloudServiceId(String cloudServiceId) {
		this.cloudServiceId = cloudServiceId;
	}

	@JoinColumn(name="account_id")
	public CloudUserDao getAccount() {
		return account;
	}
	
	public void setAccount(CloudUserDao account) {
		this.account = account;
	}

	@Convert(converter=BooleanTFConverter.class)
	@Column(name="billing_detail_collector_flg")
	public boolean getBillingDetailCollectorFlg() {
		return billingDetailCollectorFlg;
	}
	
	public void setBillingDetailCollectorFlg(boolean billingDetailCollectorFlg) {
		this.billingDetailCollectorFlg = billingDetailCollectorFlg;
	}

	@Column(name="retention_period")
	public int getRetentionPeriod() {
		return retentionPeriod;
	}
	
	public void setRetentionPeriod(int retentionPeriod) {
		this.retentionPeriod = retentionPeriod;
	}
	
	@Column(name="description")
	public String getDescription() {
		return description;
	}
	
	public void setDescription(String description) {
		this.description = description;
	}

	@Column(name="billing_last_date")
	public Timestamp getBillingLastDate() {
		return billingLastDate;
	}
	public void setBillingLastDate(Timestamp billingLastDate) {
		this.billingLastDate = billingLastDate;
	}


	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
// CloudAccountResourceDao と CloudUser は、相互参照のため、以下のコードは、循環してしまう。循環を回避するためコメントアウト。
//		result = prime * result + ((account == null) ? 0 : account.hashCode());
		result = prime
				* result
				+ ((accountResourceId == null) ? 0 : accountResourceId
						.hashCode());
		result = prime
				* result
				+ ((accountResourceName == null) ? 0 : accountResourceName
						.hashCode());
		result = prime * result + (billingDetailCollectorFlg ? 1231 : 1237);
		result = prime * result
				+ ((billingLastDate == null) ? 0 : billingLastDate.hashCode());
		result = prime * result
				+ ((cloudServiceId == null) ? 0 : cloudServiceId.hashCode());
		result = prime * result
				+ ((description == null) ? 0 : description.hashCode());
		result = prime * result + retentionPeriod;
		return result;
	}
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		CloudAccountResourceDao other = (CloudAccountResourceDao) obj;

// CloudAccountResourceDao と CloudUser は、相互参照のため、以下のコードは、循環してしまう。循環を回避するためコメントアウト。
//		if (account == null) {
//			if (other.account != null)
//				return false;
//		} else if (!account.equals(other.account))
//			return false;
		if (accountResourceId == null) {
			if (other.accountResourceId != null)
				return false;
		} else if (!accountResourceId.equals(other.accountResourceId))
			return false;
		if (accountResourceName == null) {
			if (other.accountResourceName != null)
				return false;
		} else if (!accountResourceName.equals(other.accountResourceName))
			return false;
		if (billingDetailCollectorFlg != other.billingDetailCollectorFlg)
			return false;
		if (billingLastDate == null) {
			if (other.billingLastDate != null)
				return false;
		} else if (!billingLastDate.equals(other.billingLastDate))
			return false;
		if (cloudServiceId == null) {
			if (other.cloudServiceId != null)
				return false;
		} else if (!cloudServiceId.equals(other.cloudServiceId))
			return false;
		if (description == null) {
			if (other.description != null)
				return false;
		} else if (!description.equals(other.description))
			return false;
		if (retentionPeriod != other.retentionPeriod)
			return false;
		return true;
	}
	@Override
	public String toString() {
		return "CloudAccountResourceDao [accountResourceId="
				+ accountResourceId + ", accountResourceName="
				+ accountResourceName + ", cloudServiceId=" + cloudServiceId
				// CloudAccountResourceDao と CloudUser は、相互参照のため、以下のコードは、循環してしまう。循環を回避するためコメントアウト。
				/*+ ", account=" + account*/ + ", billingDetailCollectorFlg="
				+ billingDetailCollectorFlg + ", retentionPeriod="
				+ retentionPeriod + ", description=" + description
				+ ", billingLastDate=" + billingLastDate + "]";
	}

	@Override
	public String getId() {
		return getAccountResourceId();
	}
}
