/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.util;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.bean.CloudUser;

public class CloudCredential implements IResourceManagement.ICredential {
	private String accessKey;
	private String secretKey;

	public CloudCredential(String accessKey, String secretKey) {
		this.accessKey = accessKey;
		this.secretKey = secretKey;
	}

	public CloudCredential(CloudUser cloudUser) {
		this.accessKey = cloudUser.getAccessKey();
		this.secretKey = cloudUser.getSecretKey();
	}

	@Override
	public String getAccessKey() throws CloudManagerFault {
    	return accessKey;
	}

	@Override
	public String getSecretKey() throws CloudManagerFault {
    	return secretKey;
	}
}
