/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.clustercontrol.cloud.PluginFault;

public class ObjectChangedService implements IObjectChangedService {
	private static class Key {
		private String type;
		private Class<?> clazz;

		public Key(String type, Class<?> clazz) {
			super();
			this.type = type;
			this.clazz = clazz;
		}
		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime * result + ((clazz == null) ? 0 : clazz.hashCode());
			result = prime * result + ((type == null) ? 0 : type.hashCode());
			return result;
		}
		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			Key other = (Key) obj;
			if (clazz == null) {
				if (other.clazz != null)
					return false;
			} else if (!clazz.equals(other.clazz))
				return false;
			if (type == null) {
				if (other.type != null)
					return false;
			} else if (!type.equals(other.type))
				return false;
			return true;
		}
	}
	
	
	
	private Map<Key, List<IObjectChangedListener<?>>> listenersMap = new HashMap<>();
	
	@Override
	public <T> void addObjectChangedListener(String type, Class<T> clazz, IObjectChangedListener<T> listener) {
		List<IObjectChangedListener<?>> list = listenersMap.get(new Key(type, clazz));
		if (list == null) {
			list = new ArrayList<>();
			listenersMap.put(new Key(type, clazz), list);
		}
		listener.onInstall();
		list.add(listener);
	}

	@Override
	public <T> void removeObjectChangedListener(String type, Class<T> clazz, IObjectChangedListener<T> listener) {
		List<IObjectChangedListener<?>> list = listenersMap.get(new Key(type, clazz));
		if (list != null) {
			list.remove(listener);
			listener.onUninstall();
		}
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> void firePostAddedEvent(String type, Class<T> clazz, T object) throws PluginFault {
		List<IObjectChangedListener<?>> list = listenersMap.get(new Key(type, clazz));
		if (list == null) return;

		for (IObjectChangedListener<?> listener: list) {
			((IObjectChangedListener<T>)listener).postAdded(type, object);
		}
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> void firePreRemovedEvent(String type, Class<T> clazz, T object) throws PluginFault {
		List<IObjectChangedListener<?>> list = listenersMap.get(new Key(type, clazz));
		if (list == null) return;

		for (IObjectChangedListener<?> listener: list) {
			((IObjectChangedListener<T>)listener).preRemoved(type, object);
		}
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> void firePostModifiedEvent(String type, Class<T> clazz, T object) throws PluginFault {
		List<IObjectChangedListener<?>> list = listenersMap.get(new Key(type, clazz));
		if (list == null) return;

		for (IObjectChangedListener<?> listener: list) {
			((IObjectChangedListener<T>)listener).postModified(type, object);
		}
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> void firePreAddedEvent(String type, Class<T> clazz, T object) throws PluginFault {
		List<IObjectChangedListener<?>> list = listenersMap.get(new Key(type, clazz));
		if (list == null) return;

		for (IObjectChangedListener<?> listener: list) {
			((IObjectChangedListener<T>)listener).preAdded(type, object);
		}
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> void firePreModifiedEvent(String type, Class<T> clazz, T object) throws PluginFault {
		List<IObjectChangedListener<?>> list = listenersMap.get(new Key(type, clazz));
		if (list == null) return;
		
		for (IObjectChangedListener<?> listener: list) {
			((IObjectChangedListener<T>)listener).preModified(type, object);
		}
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> void firePostRemovedEvent(String type, Class<T> clazz, T object)
			throws PluginFault {
		List<IObjectChangedListener<?>> list = listenersMap.get(new Key(type, clazz));
		if (list == null) return;
		
		for (IObjectChangedListener<?> listener: list) {
			((IObjectChangedListener<T>)listener).postRemoved(type, object);
		}
	}
}
