/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.validation;

import java.lang.reflect.Method;

import com.clustercontrol.cloud.IMessagesHolder;

public interface MethodValidator {
	public interface ParamValidatorInfo {
		void validate(Object parameter, String group, IMessagesHolder messages) throws ValidationFault;
	}

	public interface MethodValidationContext {
		Method method();
		String validationGroup();
		void validate(Object[] params, IMessagesHolder messages) throws ValidationFault;
		ParamValidatorInfo[] getPropValidators();
		CustomMethodValidator[] getCustomMethodValidators();
	}

	void validate(Method method, Object[] params) throws ValidationFault;

	MethodValidationContext getMethodContext(Method method);
}
