/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn.base.resources;

import com.clustercontrol.cloud.cloudn.base.Activator;
import com.clustercontrol.cloud.cloudn.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.cloudn.base.resources.DiskOffering;
import com.clustercontrol.cloud.cloudn.base.resources.Filter;
import com.clustercontrol.cloud.cloudn.base.resources.Network;
import com.clustercontrol.cloud.cloudn.base.resources.SecurityGroup;
import com.clustercontrol.cloud.cloudn.base.resources.ServiceOffering;
import com.clustercontrol.cloud.cloudn.base.resources.Snapshot;
import com.clustercontrol.cloud.cloudn.base.resources.Template;
import com.clustercontrol.cloud.cloudn.base.resources.Zone;
import com.clustercontrol.cloud.commons.util.AccountControlUtil;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudRegion;
import com.clustercontrol.ws.cloud.Image;
import com.clustercontrol.ws.cloudn.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloudn.CloudnOptionEndpoint;
import com.clustercontrol.ws.cloudn.InvalidRole_Exception;
import com.clustercontrol.ws.cloudn.InvalidUserPass_Exception;
import com.clustercontrol.ws.cloudn.Tag;
import java.util.ArrayList;
import java.util.List;

public class CloudResourceProviderImpl
implements CloudResourceProvider {
    private CloudEndpoint cloudEndpoint = (CloudEndpoint)Activator.getEndpointManager().getEndpoint(CloudEndpoint.class);
    private CloudnOptionEndpoint cloudnOptionEndpoint = (CloudnOptionEndpoint)Activator.getEndpointManager().getEndpoint(CloudnOptionEndpoint.class);
    private String serviceId;
    private String roleId;

    public CloudResourceProviderImpl(String accountResourceId) {
        this.serviceId = com.clustercontrol.cloud.Activator.getDefault().getCloudResourceManager().getAccountResourceManager().getAccountResource(accountResourceId).getCloudServiceId();
        this.roleId = AccountControlUtil.getRoleId((String)accountResourceId);
    }

    @Override
    public List<String> getAllRegion() {
        try {
            ArrayList<String> regions = new ArrayList<String>();
            for (CloudRegion r : this.cloudEndpoint.getCloudRegionsByService(this.serviceId)) {
                regions.add(r.getRegion());
            }
            return regions;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<Zone> getZones(String region) {
        try {
            ArrayList<Zone> azs = new ArrayList<Zone>();
            for (com.clustercontrol.ws.cloud.Zone wsAZ : this.cloudEndpoint.getZones(this.roleId, region)) {
                Zone az = new Zone();
                az.setName(wsAZ.getName());
                azs.add(az);
            }
            return azs;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<Template> getTemplates(String region, List<Filter> filters) {
        try {
            ArrayList<com.clustercontrol.ws.cloud.Filter> wsFilters = new ArrayList<com.clustercontrol.ws.cloud.Filter>();
            for (Filter filter : filters) {
                com.clustercontrol.ws.cloud.Filter wsFilter = new com.clustercontrol.ws.cloud.Filter();
                wsFilter.setName(filter.getName());
                wsFilter.getValues().addAll(filter.getValues());
                wsFilters.add(wsFilter);
            }
            ArrayList<Template> templates = new ArrayList<Template>();
            for (Image wsImage : this.cloudEndpoint.getImagesWithFilter(this.roleId, region, wsFilters)) {
                Template template = new Template(wsImage.getImageId(), wsImage.getName(), wsImage.getDescription());
                templates.add(template);
            }
            return templates;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<Network> getNetworksByRegion(String regionName) {
        try {
            List ns = this.cloudnOptionEndpoint.getNetworks(this.roleId, regionName);
            ArrayList<Network> networks = new ArrayList<Network>();
            for (com.clustercontrol.ws.cloudn.Network n : ns) {
                Network network = new Network();
                network.setNetworkId(n.getNetworkId());
                network.setName(n.getName());
                network.setZone(n.getAvailabilityZone());
                network.setCidrBlock(n.getCidrBlock());
                network.setVpcId(n.getVpcId());
                networks.add(network);
            }
            return networks;
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public List<ServiceOffering> getServiceOfferings() {
        try {
            List flavors = this.cloudEndpoint.getInstanceFlavorsByService(this.serviceId);
            ArrayList<ServiceOffering> offerings = new ArrayList<ServiceOffering>();
            for (String flavor : flavors) {
                ServiceOffering offering = new ServiceOffering();
                offering.setName(flavor);
                offerings.add(offering);
            }
            return offerings;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<Snapshot> getSnapshots(String region, List<Filter> filters) {
        try {
            ArrayList<com.clustercontrol.ws.cloud.Filter> wsFilters = new ArrayList<com.clustercontrol.ws.cloud.Filter>();
            if (filters != null) {
                for (Filter filter : filters) {
                    com.clustercontrol.ws.cloud.Filter wsFilter = new com.clustercontrol.ws.cloud.Filter();
                    wsFilter.setName(filter.getName());
                    wsFilter.getValues().addAll(filter.getValues());
                    wsFilters.add(wsFilter);
                }
            }
            ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>();
            for (com.clustercontrol.ws.cloud.Snapshot ws : this.cloudEndpoint.getSnapshotsWithFilter(this.roleId, region, wsFilters)) {
                Snapshot s = new Snapshot();
                s.setId(ws.getSnapshotId());
                s.setName(ws.getDescription());
                snapshots.add(s);
            }
            return snapshots;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<DiskOffering> getDiskOfferings() {
        try {
            ArrayList<DiskOffering> offerings = new ArrayList<DiskOffering>();
            for (String flavor : this.cloudEndpoint.getStorageFlavorsByService(this.serviceId)) {
                DiskOffering offering = new DiskOffering();
                offering.setName(flavor);
                offerings.add(offering);
            }
            return offerings;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<SecurityGroup> getSecurityGroups(String regionName) {
        try {
            ArrayList<SecurityGroup> securityGroups = new ArrayList<SecurityGroup>();
            for (com.clustercontrol.ws.cloudn.SecurityGroup wsSecurityGroup : this.cloudnOptionEndpoint.getSecurityGroups(this.roleId, regionName)) {
                SecurityGroup securityGroup = new SecurityGroup();
                securityGroup.setId(wsSecurityGroup.getId());
                securityGroup.setName(wsSecurityGroup.getName());
                securityGroup.setDescription(wsSecurityGroup.getDescription());
                if (wsSecurityGroup.getTags() != null && !wsSecurityGroup.getTags().isEmpty()) {
                    securityGroup.setTags(new ArrayList<com.clustercontrol.cloud.resources.Tag>());
                    for (Tag tag : wsSecurityGroup.getTags()) {
                        securityGroup.getTags().add(new com.clustercontrol.cloud.resources.Tag(tag.getKey(), tag.getValue()));
                    }
                }
                securityGroups.add(securityGroup);
            }
            return securityGroups;
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }
}

