/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn.base.ui.dialogs;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.cloudn.base.commons.util.CloudnConstants;
import com.clustercontrol.cloud.cloudn.base.commons.util.ControlUtilEx;
import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.cloudn.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.cloudn.base.resources.Filter;
import com.clustercontrol.cloud.cloudn.base.resources.Network;
import com.clustercontrol.cloud.cloudn.base.resources.ServiceOffering;
import com.clustercontrol.cloud.cloudn.base.resources.Template;
import com.clustercontrol.cloud.cloudn.base.resources.Zone;
import com.clustercontrol.cloud.cloudn.base.ui.dialogs.EditTagsDialog;
import com.clustercontrol.cloud.cloudn.base.ui.dialogs.SelectVMIDialog;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.ValidateException;
import com.clustercontrol.cloud.commons.util.annotation.RelationalRequiredSelect;
import com.clustercontrol.cloud.commons.util.annotation.RequiredInput;
import com.clustercontrol.cloud.commons.util.annotation.RequiredSelect;
import com.clustercontrol.cloud.presenter.CreateCloudInstanceRequest;
import com.clustercontrol.cloud.presenter.ICloudTemplate;
import com.clustercontrol.cloud.presenter.ICloudTemplateManager;
import com.clustercontrol.cloud.presenter.TemplateJobsArgument;
import com.clustercontrol.cloud.resources.Tag;
import com.clustercontrol.cloud.ui.dialogs.EditTemplateJobArgumentDialog;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class CreateInstanceDialog
extends Dialog
implements CloudnConstants {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String strSeparator = this.messages.getString("caption.title_separator");
    private String strNodeInfo = this.messages.getString("word.node_info");
    private String strFacilityId = this.messages.getString("word.facility_id");
    private String strNodeReplaceDescription = this.messages.getString("caption.node_replace_description");
    private String strFacilityName = this.messages.getString("word.facility_name");
    private String strDescription = this.messages.getString("word.description");
    private String strNodeName = this.messages.getString("word.node_name");
    private String strInstanceInfo = this.messages.getString("word.instance_info");
    private String strZone = this.messages.getString("word.zone");
    private String strNetwork = this.messages.getString("word.network");
    private String strVmi = this.messages.getString("word.virtual_machine_image");
    private String strRefer = this.messages.getString("word.refer");
    private String strUseTemplate = this.messages.getString("caption.use_subjects", new Object[]{"word.template"});
    private String strTemplate = this.messages.getString("word.template");
    private String strEditArgument = this.messages.getString("caption.edit_argument");
    private String strAttachingDisk = this.messages.getString("caption.attaching_disk");
    private String strInstanceFlavor = this.messages.getString("word.instance_type");
    private String strCreateInstanceDialog = this.messages.getString("caption.create_instance_dialog");
    private String strGroup = this.messages.getString("word.group");
    private String strEditTags = this.messages.getString("caption.edit_tags");
    private String msgTemplateDoesNotExists = this.messages.getString("message.template_does_not_exists");
    private Shell shell;
    @RequiredInput(value="strFacilityId")
    private Text txtFacilityId;
    private Button btnReplaceNode;
    @RequiredInput(value="strFacilityName")
    private Text txtFacilityName;
    private Text txtDescription;
    @RequiredInput(value="strNodeName")
    private Text txtNodeName;
    @RequiredSelect(value="strZone")
    private Combo cmbZone;
    private Text txtVMI;
    @RelationalRequiredSelect(name="btnUseTemplate", value="strTemplate")
    private Combo cmbTemplate;
    private Button btnUseTemplate;
    private Button btnSelectVMI;
    private Button btnEditArgument;
    private Button btnEditTags;
    @RequiredSelect(value="strNetwork")
    private Combo cmbNetwork;
    @RequiredSelect(value="strFlavor")
    private Combo cmbFlavor;
    private Text txtGroup;
    private Button btnAttachingDisk;
    private CloudResourceProvider provider;
    private String region = "jp-e1";
    private Model output = new Model();
    private List<Tag> tags = new ArrayList<Tag>();
    private ICloudTemplateManager cloudTemplateManager;
    private Label lblZone;
    private Label lblVMI;
    private Label lblUseTemplate;
    private Label lblTemplate;
    private Label lblNetwork;
    private Label lblGroup;
    private Label lblFlavor;
    private Label lblAttachingDisk;
    private List<TemplateJobsArgument> arguments;
    private List<Network> networks = new ArrayList<Network>();
    private IDialogBehavior behavior = new DialogBehavior();

    public void setCloudTemplateManager(ICloudTemplateManager cloudTemplateManager) {
        this.cloudTemplateManager = cloudTemplateManager;
    }

    public void setBehavior(IDialogBehavior behavior) {
        this.behavior = behavior;
    }

    public CreateInstanceDialog(Shell parentShell) {
        super(parentShell);
        this.shell = parentShell;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setBackground(SWTResourceManager.getColor((int)22));
        GridLayout gl_container = new GridLayout(1, false);
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(1808);
        gd_container.widthHint = 614;
        container.setLayoutData((Object)gd_container);
        Group grpNodeInfo = new Group(container, 0);
        GridLayout gl_grpNodeInfo = new GridLayout(2, false);
        gl_grpNodeInfo.verticalSpacing = 9;
        gl_grpNodeInfo.horizontalSpacing = 15;
        grpNodeInfo.setLayout((Layout)gl_grpNodeInfo);
        grpNodeInfo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 5, 1));
        Label lblid = new Label((Composite)grpNodeInfo, 131072);
        lblid.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.txtFacilityId = new Text((Composite)grpNodeInfo, 2048);
        this.txtFacilityId.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label((Composite)grpNodeInfo, 0);
        this.btnReplaceNode = new Button((Composite)grpNodeInfo, 32);
        Label lblFacilityName = new Label((Composite)grpNodeInfo, 131072);
        lblFacilityName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.txtFacilityName = new Text((Composite)grpNodeInfo, 2048);
        this.txtFacilityName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Label lblDescription = new Label((Composite)grpNodeInfo, 131072);
        lblDescription.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.txtDescription = new Text((Composite)grpNodeInfo, 2048);
        this.txtDescription.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Label lblNodeName = new Label((Composite)grpNodeInfo, 131072);
        lblNodeName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.txtNodeName = new Text((Composite)grpNodeInfo, 2048);
        GridData gd_nodeName = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_nodeName.widthHint = 66;
        this.txtNodeName.setLayoutData((Object)gd_nodeName);
        Group grpInstacneInfo = new Group(container, 0);
        GridLayout gl_grpInstacneInfo = new GridLayout(3, false);
        gl_grpInstacneInfo.verticalSpacing = 9;
        gl_grpInstacneInfo.horizontalSpacing = 15;
        grpInstacneInfo.setLayout((Layout)gl_grpInstacneInfo);
        GridData gd_grpInstacneInfo = new GridData(4, 0x1000000, false, false, 5, 1);
        gd_grpInstacneInfo.heightHint = 350;
        grpInstacneInfo.setLayoutData((Object)gd_grpInstacneInfo);
        this.lblZone = new Label((Composite)grpInstacneInfo, 0);
        this.lblZone.setAlignment(131072);
        this.lblZone.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.cmbZone = new Combo((Composite)grpInstacneInfo, 8);
        this.cmbZone.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.lblVMI = new Label((Composite)grpInstacneInfo, 0);
        this.lblVMI.setAlignment(131072);
        this.lblVMI.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.txtVMI = new Text((Composite)grpInstacneInfo, 2056);
        GridData gd_txtVMI = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtVMI.widthHint = 100;
        this.txtVMI.setLayoutData((Object)gd_txtVMI);
        this.btnSelectVMI = new Button((Composite)grpInstacneInfo, 0);
        this.btnSelectVMI.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblUseTemplate = new Label((Composite)grpInstacneInfo, 0);
        this.lblUseTemplate.setAlignment(131072);
        this.lblUseTemplate.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnUseTemplate = new Button((Composite)grpInstacneInfo, 32);
        this.btnUseTemplate.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnUseTemplate.setAlignment(131072);
        new Label((Composite)grpInstacneInfo, 0);
        this.lblTemplate = new Label((Composite)grpInstacneInfo, 0);
        this.lblTemplate.setEnabled(false);
        this.lblTemplate.setAlignment(131072);
        this.lblTemplate.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.cmbTemplate = new Combo((Composite)grpInstacneInfo, 2056);
        this.cmbTemplate.setEnabled(false);
        GridData gd_cmbTemplate = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_cmbTemplate.widthHint = 100;
        this.cmbTemplate.setLayoutData((Object)gd_cmbTemplate);
        this.btnEditArgument = new Button((Composite)grpInstacneInfo, 0);
        this.btnEditArgument.setEnabled(false);
        this.btnEditArgument.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        new Label((Composite)grpInstacneInfo, 0);
        new Label((Composite)grpInstacneInfo, 0);
        new Label((Composite)grpInstacneInfo, 0);
        this.lblFlavor = new Label((Composite)grpInstacneInfo, 0);
        this.lblFlavor.setAlignment(131072);
        this.lblFlavor.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.cmbFlavor = new Combo((Composite)grpInstacneInfo, 2048);
        GridData gd_cmbFlavor = new GridData(4, 0x1000000, true, false, 2, 1);
        gd_cmbFlavor.widthHint = 100;
        this.cmbFlavor.setLayoutData((Object)gd_cmbFlavor);
        this.lblNetwork = new Label((Composite)grpInstacneInfo, 0);
        this.lblNetwork.setAlignment(131072);
        this.lblNetwork.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.cmbNetwork = new Combo((Composite)grpInstacneInfo, 2048);
        GridData gd_cmbNetwork = new GridData(4, 0x1000000, true, false, 2, 1);
        gd_cmbNetwork.widthHint = 100;
        this.cmbNetwork.setLayoutData((Object)gd_cmbNetwork);
        this.lblGroup = new Label((Composite)grpInstacneInfo, 0);
        this.lblGroup.setAlignment(131072);
        this.lblGroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.txtGroup = new Text((Composite)grpInstacneInfo, 2048);
        this.txtGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.lblAttachingDisk = new Label((Composite)grpInstacneInfo, 0);
        this.lblAttachingDisk.setAlignment(131072);
        this.lblAttachingDisk.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnAttachingDisk = new Button((Composite)grpInstacneInfo, 32);
        this.btnAttachingDisk.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnAttachingDisk.setAlignment(131072);
        new Label((Composite)grpInstacneInfo, 0);
        new Label((Composite)grpInstacneInfo, 0);
        new Label((Composite)grpInstacneInfo, 0);
        this.btnEditTags = new Button((Composite)grpInstacneInfo, 0);
        this.btnEditTags.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.cmbZone.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateInstanceDialog.this.txtVMI.setText("");
                CreateInstanceDialog.this.txtVMI.setData(null);
                CreateInstanceDialog.this.cmbNetwork.removeAll();
                for (Network n : CreateInstanceDialog.this.networks) {
                    if (!n.getZone().equals(CreateInstanceDialog.this.cmbZone.getText())) continue;
                    String name = n.getName() + "(" + n.getCidrBlock() + ")";
                    CreateInstanceDialog.this.cmbNetwork.add(name);
                    CreateInstanceDialog.this.cmbNetwork.setData(name, (Object)n);
                }
                CreateInstanceDialog.this.cmbNetwork.select(0);
                CreateInstanceDialog.this.cmbTemplate.removeAll();
                if (CreateInstanceDialog.this.btnUseTemplate.getSelection()) {
                    for (ICloudTemplate tmpTemplate : CreateInstanceDialog.this.cloudTemplateManager.getCloudTemplates()) {
                        if (!tmpTemplate.getRegion().equals(CreateInstanceDialog.this.region) || !tmpTemplate.getImageId().substring(37).equals(CreateInstanceDialog.this.cmbZone.getText())) continue;
                        String tmpLabel = tmpTemplate.getTemplateName() + " ( " + tmpTemplate.getTemplateId() + " )";
                        CreateInstanceDialog.this.cmbTemplate.add(tmpLabel);
                        CreateInstanceDialog.this.cmbTemplate.setData(tmpLabel, (Object)tmpTemplate);
                    }
                    if (CreateInstanceDialog.this.cmbTemplate.getItemCount() > 0) {
                        CreateInstanceDialog.this.cmbTemplate.select(0);
                        CreateInstanceDialog.this.lblTemplate.setEnabled(true);
                        CreateInstanceDialog.this.cmbTemplate.setEnabled(true);
                        CreateInstanceDialog.this.btnEditArgument.setEnabled(true);
                        CreateInstanceDialog.this.lblVMI.setEnabled(false);
                        CreateInstanceDialog.this.txtVMI.setEnabled(false);
                        CreateInstanceDialog.this.btnSelectVMI.setEnabled(false);
                        CreateInstanceDialog.this.txtVMI.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                    } else {
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)CreateInstanceDialog.this.msgTemplateDoesNotExists);
                        CreateInstanceDialog.this.btnUseTemplate.setSelection(false);
                        CreateInstanceDialog.this.lblTemplate.setEnabled(false);
                        CreateInstanceDialog.this.cmbTemplate.setEnabled(false);
                        CreateInstanceDialog.this.btnEditArgument.setEnabled(false);
                        CreateInstanceDialog.this.lblVMI.setEnabled(true);
                        CreateInstanceDialog.this.txtVMI.setEnabled(true);
                        CreateInstanceDialog.this.btnSelectVMI.setEnabled(true);
                    }
                }
                if (!CreateInstanceDialog.this.btnUseTemplate.getSelection()) {
                    CreateInstanceDialog.this.txtVMI.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                }
            }
        });
        this.btnUseTemplate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateInstanceDialog.this.btnUseTemplate.getSelection()) {
                    if (CreateInstanceDialog.this.cmbTemplate.getItemCount() == 0) {
                        for (ICloudTemplate tmpTemplate : CreateInstanceDialog.this.cloudTemplateManager.getCloudTemplates()) {
                            if (!tmpTemplate.getRegion().equals(CreateInstanceDialog.this.region) || !tmpTemplate.getImageId().substring(37).equals(CreateInstanceDialog.this.cmbZone.getText())) continue;
                            String tmpLabel = tmpTemplate.getTemplateName() + " ( " + tmpTemplate.getTemplateId() + " )";
                            CreateInstanceDialog.this.cmbTemplate.add(tmpLabel);
                            CreateInstanceDialog.this.cmbTemplate.setData(tmpLabel, (Object)tmpTemplate);
                        }
                        if (CreateInstanceDialog.this.cmbTemplate.getItemCount() > 0) {
                            CreateInstanceDialog.this.cmbTemplate.select(0);
                        }
                    }
                    if (CreateInstanceDialog.this.cmbTemplate.getItemCount() > 0) {
                        CreateInstanceDialog.this.lblTemplate.setEnabled(true);
                        CreateInstanceDialog.this.cmbTemplate.setEnabled(true);
                        CreateInstanceDialog.this.btnEditArgument.setEnabled(true);
                        CreateInstanceDialog.this.lblVMI.setEnabled(false);
                        CreateInstanceDialog.this.txtVMI.setEnabled(false);
                        CreateInstanceDialog.this.btnSelectVMI.setEnabled(false);
                        CreateInstanceDialog.this.txtVMI.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                    } else {
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)CreateInstanceDialog.this.msgTemplateDoesNotExists);
                        CreateInstanceDialog.this.btnUseTemplate.setSelection(false);
                    }
                } else {
                    CreateInstanceDialog.this.lblTemplate.setEnabled(false);
                    CreateInstanceDialog.this.cmbTemplate.setEnabled(false);
                    CreateInstanceDialog.this.btnEditArgument.setEnabled(false);
                    CreateInstanceDialog.this.lblVMI.setEnabled(true);
                    CreateInstanceDialog.this.txtVMI.setEnabled(true);
                    CreateInstanceDialog.this.btnSelectVMI.setEnabled(true);
                    if (CreateInstanceDialog.this.txtVMI.getText().equals("")) {
                        CreateInstanceDialog.this.txtVMI.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                    }
                }
            }
        });
        this.btnSelectVMI.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<Template> officials = CreateInstanceDialog.this.provider.getTemplates(CreateInstanceDialog.this.region, Arrays.asList(new Filter("category", "official"), new Filter("zone", CreateInstanceDialog.this.cmbZone.getText())));
                List<Template> mys = CreateInstanceDialog.this.provider.getTemplates(CreateInstanceDialog.this.region, Arrays.asList(new Filter("category", "my"), new Filter("zone", CreateInstanceDialog.this.cmbZone.getText())));
                SelectVMIDialog dialog = new SelectVMIDialog(officials, mys, CreateInstanceDialog.this.shell);
                if (dialog.open() == 0) {
                    Template output = dialog.getOutput();
                    CreateInstanceDialog.this.txtVMI.setText(output.getName() + " ( " + output.getId() + " ) ");
                    CreateInstanceDialog.this.txtVMI.setData((Object)output);
                }
            }
        });
        this.btnEditArgument.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateInstanceDialog.this.cmbTemplate.getText().equals("")) {
                    return;
                }
                ICloudTemplate tmpTemplate = (ICloudTemplate)CreateInstanceDialog.this.cmbTemplate.getData(CreateInstanceDialog.this.cmbTemplate.getText());
                if (tmpTemplate == null || tmpTemplate.getLaunchJobId() == null || tmpTemplate.getLaunchJobId().equals("")) {
                    return;
                }
                EditTemplateJobArgumentDialog dialog = new EditTemplateJobArgumentDialog(CreateInstanceDialog.this.shell, CreateInstanceDialog.this.cloudTemplateManager.getAccountResource().getAccountResourceId(), tmpTemplate.getTemplateId(), tmpTemplate.getLaunchJobId());
                if (dialog.open() == 0) {
                    CreateInstanceDialog.this.arguments = dialog.getArguments();
                }
            }
        });
        this.btnEditTags.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditTagsDialog dialog = new EditTagsDialog(CreateInstanceDialog.this.shell, CreateInstanceDialog.this.tags);
                if (dialog.open() == 0) {
                    CreateInstanceDialog.this.tags.clear();
                    CreateInstanceDialog.this.tags.addAll(dialog.getOutput());
                }
            }
        });
        grpNodeInfo.setText(this.strNodeInfo + this.strSeparator);
        lblid.setText(this.strFacilityId + this.strSeparator);
        this.btnReplaceNode.setText(this.strNodeReplaceDescription);
        lblFacilityName.setText(this.strFacilityName + this.strSeparator);
        lblDescription.setText(this.strDescription + this.strSeparator);
        lblNodeName.setText(this.strNodeName + this.strSeparator);
        grpInstacneInfo.setText(this.strInstanceInfo);
        this.lblZone.setText(this.strZone + this.strSeparator);
        this.lblVMI.setText(this.strVmi + this.strSeparator);
        this.btnSelectVMI.setText(this.strRefer);
        this.lblTemplate.setText(this.strTemplate + this.strSeparator);
        this.btnEditArgument.setText(this.strEditArgument);
        this.lblFlavor.setText(this.strInstanceFlavor + this.strSeparator);
        this.lblUseTemplate.setText(this.strUseTemplate + this.strSeparator);
        this.lblNetwork.setText(this.strNetwork + this.strSeparator);
        this.lblGroup.setText(this.strGroup + this.strSeparator);
        this.lblAttachingDisk.setText(this.strAttachingDisk + this.strSeparator);
        this.btnEditTags.setText(this.strEditTags);
        this.lblAttachingDisk.setVisible(false);
        this.btnAttachingDisk.setVisible(false);
        List<Zone> zones = this.provider.getZones(this.region);
        for (Zone z : zones) {
            this.cmbZone.add(z.getName());
        }
        this.cmbZone.select(0);
        List<ServiceOffering> sos = this.provider.getServiceOfferings();
        for (ServiceOffering so : sos) {
            this.cmbFlavor.add(so.getName());
        }
        this.cmbFlavor.select(0);
        this.networks.addAll(this.provider.getNetworksByRegion(this.region));
        for (Network n : this.networks) {
            if (!n.getZone().equals(this.cmbZone.getText())) continue;
            String name = n.getName() + "  (" + n.getCidrBlock() + ")";
            this.cmbNetwork.add(name);
            this.cmbNetwork.setData(name, (Object)n);
        }
        this.cmbNetwork.select(0);
        ControlUtilEx.setRequired(new Control[]{this.txtFacilityId, this.txtFacilityName, this.txtNodeName, this.txtVMI, this.cmbNetwork, this.cmbFlavor});
        this.behavior.setup(new DialogControlContainer(this.txtFacilityId, this.btnReplaceNode, this.txtFacilityName, this.txtDescription, this.txtNodeName, this.cmbZone, this.txtVMI, this.cmbTemplate, this.btnUseTemplate, this.btnSelectVMI, this.btnEditArgument, this.btnEditTags, this.cmbNetwork, this.cmbFlavor, this.txtGroup, this.lblVMI, this.lblTemplate, this.lblAttachingDisk, this.btnAttachingDisk));
        container.layout();
        Control[] labels = new Control[]{lblid, lblFacilityName, lblDescription, lblNodeName, this.lblZone, this.lblVMI, this.lblUseTemplate, this.lblTemplate, this.lblNetwork, this.lblFlavor, this.lblGroup, this.lblAttachingDisk};
        int maxWidth = 0;
        for (Control l : labels) {
            Point p = l.getSize();
            maxWidth = Math.max(maxWidth, p.x);
        }
        for (Control l : labels) {
            ((GridData)l.getLayoutData()).widthHint = maxWidth;
        }
        grpNodeInfo.layout(true);
        grpInstacneInfo.layout(true);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(640, 690);
    }

    protected void okPressed() {
        try {
            ControlUtil.validate((Dialog)this);
        }
        catch (ValidateException e) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)e.getMessage());
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!this.btnUseTemplate.getSelection() && this.txtVMI.getText().equals("")) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.messages.getString("validation.required_input.message", new String[]{this.strVmi}));
            return;
        }
        this.output.setFacilityId(this.txtFacilityId.getText());
        this.output.setFacilityName(this.txtFacilityName.getText());
        this.output.setDescription(this.txtDescription.getText());
        this.output.setNodeName(this.txtNodeName.getText());
        this.output.setReplaceNode(this.btnReplaceNode.getSelection());
        if (!this.btnUseTemplate.getSelection()) {
            this.output.setImageId(((Template)this.txtVMI.getData()).getId());
            this.output.templateId = null;
        } else {
            this.output.templateId = ((ICloudTemplate)this.cmbTemplate.getData(this.cmbTemplate.getText())).getTemplateId();
            if (this.arguments != null && this.arguments.size() > 0) {
                this.output.arguments = this.arguments;
            }
            this.output.isTemplateUsed = true;
        }
        this.output.setFlavor(this.cmbFlavor.getText());
        this.output.setZone(this.cmbZone.getText());
        this.output.setTags(this.tags);
        this.output.setGroup(this.txtGroup.getText());
        this.output.setNetworkId(((Network)this.cmbNetwork.getData(this.cmbNetwork.getText())).getNetworkId());
        this.output.setAttachingDisk(this.btnAttachingDisk.getSelection());
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.strCreateInstanceDialog);
    }

    public Model getOutput() {
        return this.output;
    }

    public void setCloudInfoProvider(CloudResourceProvider provider) {
        this.provider = provider;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public static class DialogControlContainer {
        private Text txtFacilityId;
        private Button btnReplaceNode;
        private Text txtFacilityName;
        private Text txtDescription;
        private Text txtNodeName;
        private Combo cmbZone;
        private Text txtVMI;
        private Combo cmbTemplate;
        private Button btnUseTemplate;
        private Button btnSelectVMI;
        private Button btnEditArgument;
        private Button btnEditTags;
        private Combo cmbNetwork;
        private Combo cmbFlavor;
        private Text txtGroup;
        private Label lblVMI;
        private Label lblTemplate;
        private Label lblAttachingDisk;
        private Button btnAttachingDisk;

        public DialogControlContainer(Text txtFacilityId, Button btnReplaceNode, Text txtFacilityName, Text txtDescription, Text txtNodeName, Combo cmbZone, Text txtVMI, Combo cmbTemplate, Button btnUseTemplate, Button btnSelectVMI, Button btnEditArgument, Button btnEditTags, Combo cmbNetwork, Combo cmbFlavor, Text txtGroup, Label lblVMI, Label lblTemplate, Label lblAttachingDisk, Button btnAttachingDisk) {
            this.txtFacilityId = txtFacilityId;
            this.btnReplaceNode = btnReplaceNode;
            this.txtFacilityName = txtFacilityName;
            this.txtDescription = txtDescription;
            this.txtNodeName = txtNodeName;
            this.cmbZone = cmbZone;
            this.txtVMI = txtVMI;
            this.cmbTemplate = cmbTemplate;
            this.btnUseTemplate = btnUseTemplate;
            this.btnSelectVMI = btnSelectVMI;
            this.btnEditArgument = btnEditArgument;
            this.btnEditTags = btnEditTags;
            this.cmbNetwork = cmbNetwork;
            this.cmbFlavor = cmbFlavor;
            this.txtGroup = txtGroup;
            this.lblVMI = lblVMI;
            this.lblTemplate = lblTemplate;
            this.lblAttachingDisk = lblAttachingDisk;
            this.btnAttachingDisk = btnAttachingDisk;
        }

        public Text getFacilityId() {
            return this.txtFacilityId;
        }

        public Button getBtnReplaceNode() {
            return this.btnReplaceNode;
        }

        public Text getFacilityName() {
            return this.txtFacilityName;
        }

        public Text getDescription() {
            return this.txtDescription;
        }

        public Text getNodeName() {
            return this.txtNodeName;
        }

        public Combo getCmbZone() {
            return this.cmbZone;
        }

        public Text getTxtVMI() {
            return this.txtVMI;
        }

        public Combo getCmbTemplate() {
            return this.cmbTemplate;
        }

        public Button getBtnUseTemplate() {
            return this.btnUseTemplate;
        }

        public Button getBtnSelectVMI() {
            return this.btnSelectVMI;
        }

        public Button getBtnEditArgument() {
            return this.btnEditArgument;
        }

        public Button getBtnEditTags() {
            return this.btnEditTags;
        }

        public Combo getCmbNetwork() {
            return this.cmbNetwork;
        }

        public Combo getCmbFlavor() {
            return this.cmbFlavor;
        }

        public Text getTxtGroup() {
            return this.txtGroup;
        }

        public Label getLblVMI() {
            return this.lblVMI;
        }

        public Label getLblTemplate() {
            return this.lblTemplate;
        }

        public Label getLblAttachingDisk() {
            return this.lblAttachingDisk;
        }

        public Button getBtnAttachingDisk() {
            return this.btnAttachingDisk;
        }
    }

    public static class DialogBehavior
    implements IDialogBehavior {
        @Override
        public void setup(DialogControlContainer container) {
        }
    }

    public static interface IDialogBehavior {
        public void setup(DialogControlContainer var1);
    }

    public static class Model
    extends CreateCloudInstanceRequest {
        private String templateId;
        private List<TemplateJobsArgument> arguments;
        private Boolean isTemplateUsed = false;
        private String group;
        private String networkId;
        private Boolean attachingDisk;

        public String getTemplateId() {
            return this.templateId;
        }

        public void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        public List<TemplateJobsArgument> getArguments() {
            return this.arguments;
        }

        public void setArguments(List<TemplateJobsArgument> arguments) {
            this.arguments = arguments;
        }

        public Boolean isTemplateUsed() {
            return this.isTemplateUsed;
        }

        public void setIsTemplateUsed(Boolean isTemplateUsed) {
            this.isTemplateUsed = isTemplateUsed;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getNetworkId() {
            return this.networkId;
        }

        public void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        public Boolean getAttachingDisk() {
            return this.attachingDisk;
        }

        public void setAttachingDisk(Boolean attachingDisk) {
            this.attachingDisk = attachingDisk;
        }
    }
}

