/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn.base.ui.views.actions;

import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.cloudn.base.ui.dialogs.BackupInstanceDialog;
import com.clustercontrol.cloud.presenter.CreateInstanceBackupRequest;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class BackupInstanceAction
extends SingleSelectionActionEx {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String msgCreateBackupConfirm = this.messages.getString("message.confirm_some_action_to_something", new Object[]{"word.instance_backup", "word.create"});
    private String msgCreateBackupResult = this.messages.getString("message.result_some_action_to_something", new Object[]{"word.instance_backup", "word.create"});

    protected void invoke(IAction action) throws InvocationException {
        ICloudInstance instance = (ICloudInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        BackupInstanceDialog dialog = new BackupInstanceDialog(this.viewPart.getSite().getShell(), instance);
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.msgCreateBackupConfirm)) {
                CreateInstanceBackupRequest request = new CreateInstanceBackupRequest();
                request.setInstanceId(instance.getInstanceId());
                request.setName(dialog.getImageName());
                request.setDescription(dialog.getDescription());
                request.setWithVolumes(dialog.getWithEBSVolume());
                request.setDetail(null);
                instance.getCloudInstanceManager().getCloudComputeService().getInstanceBackupManager().backupCloudInstance(request);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgCreateBackupResult);
            } else {
                return;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        ICloudInstance instance = (ICloudInstance)((IStructuredSelection)selection).getFirstElement();
        if (instance == null || instance.getFacilityId() == null || "".equals(instance.getFacilityId()) || instance.getRegistState().equals(ICloudInstance.RegistStateType.deleted.name())) {
            action.setEnabled(false);
        }
    }
}

