/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.plugin.monitor;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.plugin.monitor.CommonMonitorDialog;
import com.clustercontrol.cloud.plugin.monitor.MonitorBasicComposite;
import com.clustercontrol.cloud.plugin.monitor.ScopeTreeDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.repository.FacilityPath;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.monitor.MonitorInfo;
import com.clustercontrol.ws.repository.FacilityInfo;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class MonitorBasicScopeComposite
extends MonitorBasicComposite {
    private Text m_textScope = null;
    private Button m_buttonScope = null;
    private String m_facilityId = null;
    private boolean m_unregistered = false;
    private String m_ownerRoleId = null;
    private List<IChangeFacilityIdListener> listeners;

    public MonitorBasicScopeComposite(Composite parent, int style, boolean unregistered, CommonMonitorDialog parentDialog) {
        super(parent, style, parentDialog);
        this.m_unregistered = unregistered;
        this.initialize();
    }

    private void initialize() {
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 15;
        this.setLayout((Layout)layout);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"scope") + " : ");
        this.m_textScope = new Text((Composite)this, 18440);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textScope.setLayoutData((Object)gridData);
        this.m_textScope.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                MonitorBasicScopeComposite.this.update();
            }
        });
        this.m_buttonScope = new Button((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_buttonScope.setLayoutData((Object)gridData);
        this.m_buttonScope.setText(Messages.getString((String)"refer"));
        this.m_buttonScope.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ScopeTreeDialog dialog = new ScopeTreeDialog(shell, MonitorBasicScopeComposite.this.m_ownerRoleId, false, MonitorBasicScopeComposite.this.m_unregistered);
                dialog.setSelectNodeOnly(true);
                if (dialog.open() == 0) {
                    FacilityTreeItem item = dialog.getSelectItem();
                    FacilityInfo info = item.getData();
                    MonitorBasicScopeComposite.this.setFacilityId(info.getFacilityId());
                    if (info.getFacilityType() == 1) {
                        MonitorBasicScopeComposite.this.m_textScope.setText(info.getFacilityName());
                    } else {
                        FacilityPath path = new FacilityPath(ClusterControlPlugin.getDefault().getSeparator());
                        MonitorBasicScopeComposite.this.m_textScope.setText(path.getPath(item));
                    }
                }
            }
        });
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
    }

    @Override
    public void update() {
        super.update();
        if ("".equals(this.m_textScope.getText())) {
            this.m_textScope.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_textScope.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    @Override
    public void setInputData(MonitorInfo info, boolean updateFlg) {
        super.setInputData(info, updateFlg);
        if (info != null) {
            if (info.getScope() != null) {
                this.m_textScope.setText(info.getScope());
            }
            if (info.getFacilityId() != null) {
                this.setFacilityId(info.getFacilityId());
            }
        }
        this.update();
    }

    @Override
    public ValidateResult createInputData(MonitorInfo info) {
        if (info != null) {
            ValidateResult validateResult = super.createInputData(info);
            if (validateResult != null) {
                return validateResult;
            }
            if (this.m_textScope.getText() != null && !"".equals(this.m_textScope.getText().trim())) {
                info.setFacilityId(this.getFacilityId());
            }
        }
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_textScope.setEnabled(enabled);
        this.m_buttonScope.setEnabled(enabled);
    }

    @Override
    protected ValidateResult setValidateResult(String id, String message) {
        ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        return validateResult;
    }

    public Button getButtonScope() {
        return this.m_buttonScope;
    }

    public String getFacilityId() {
        return this.m_facilityId;
    }

    public void setOwnerRoleId(String ownerRoleId) {
        this.m_ownerRoleId = ownerRoleId;
        this.m_textScope.setText("");
        this.setFacilityId(null);
    }

    public String getOwnerRoleId() {
        return this.m_ownerRoleId;
    }

    public void setFacilityId(String facilityId) {
        this.m_facilityId = facilityId;
        this.notifyFacilityIdChanged();
    }

    public void notifyFacilityIdChanged() {
        if (this.listeners != null) {
            for (IChangeFacilityIdListener listener : this.listeners) {
                listener.facilityIdChanged();
            }
        }
    }

    public void addChangeFacilityIdListener(IChangeFacilityIdListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IChangeFacilityIdListener>();
        }
        this.listeners.add(listener);
    }

    public void removeChangeFacilityIdListener(IChangeFacilityIdListener listener) {
        if (this.listeners != null && this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public static interface IChangeFacilityIdListener {
        public void facilityIdChanged();
    }
}

