/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.cloud.presenter.PropChangedEventNotifier;
import com.clustercontrol.cloud.presenter.PropEvent;
import com.clustercontrol.cloud.presenter.PropertyId2;
import com.clustercontrol.cloud.presenter.PropertyObserver2;

public interface AllPropertyObserver
extends PropertyObserver2<Object> {
    public void elementAdded(ElementAddedEvent var1);

    public void elementRemoved(ElementRemovedEvent var1);

    public void propertyChanged(ValueChangedEvent var1);

    public static class ValueChangedEvent
    extends PropEvent<Object, AllPropertyObserver> {
        private Object newValue;
        private Object oldValue;
        private PropertyId2<?> realPid;

        public ValueChangedEvent(Object source, PropertyId2<AllPropertyObserver> realPid, Object newValue, Object oldValue) {
            super(source, PropChangedEventNotifier.allProperty);
            this.newValue = newValue;
            this.oldValue = oldValue;
            this.realPid = realPid;
        }

        public Object getNewValue() {
            return this.newValue;
        }

        public Object getOldValue() {
            return this.oldValue;
        }

        public PropertyId2<?> getRealPid() {
            return this.realPid;
        }

        @Override
        public void dispatch(AllPropertyObserver observer) {
            if (this.getNewValue() != null && !this.getNewValue().equals(this.getOldValue()) || this.getNewValue() != this.getOldValue()) {
                observer.propertyChanged(this);
            }
        }
    }

    public static class ElementRemovedEvent
    extends PropEvent<Object, AllPropertyObserver> {
        private Object removedValue;
        private PropertyId2<?> realPid;

        public ElementRemovedEvent(Object source, PropertyId2<?> realPid, Object addedValue) {
            super(source, PropChangedEventNotifier.allProperty);
            this.removedValue = addedValue;
            this.realPid = realPid;
        }

        public Object getRemovedElement() {
            return this.removedValue;
        }

        public PropertyId2<?> getRealPid() {
            return this.realPid;
        }

        @Override
        public void dispatch(AllPropertyObserver observer) {
            observer.elementRemoved(this);
        }
    }

    public static class ElementAddedEvent
    extends PropEvent<Object, AllPropertyObserver> {
        private Object addedElement;
        private PropertyId2<?> realPid;

        public ElementAddedEvent(Object source, PropertyId2<?> realPid, Object addedElement) {
            super(source, PropChangedEventNotifier.allProperty);
            this.addedElement = addedElement;
            this.realPid = realPid;
        }

        public PropertyId2<?> getRealPid() {
            return this.realPid;
        }

        public Object getAddedElement() {
            return this.addedElement;
        }

        @Override
        public void dispatch(AllPropertyObserver observer) {
            observer.elementAdded(this);
        }
    }
}

