/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.Element;
import com.clustercontrol.cloud.presenter.IInternalComponent;
import com.clustercontrol.cloud.presenter.IInternalContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class InternalContainer<C extends IInternalComponent<?, S>, S>
extends Element
implements IInternalContainer<C, S> {
    private List<C> components;

    public boolean isInitialized() {
        return this.components != null;
    }

    @Override
    public List<C> getComponents() {
        if (!this.isInitialized()) {
            this.update();
        }
        return this.components;
    }

    protected abstract List<S> getSources() throws CloudModelException;

    protected abstract C createComponent(S var1) throws CloudModelException;

    @Override
    public void update() throws CloudModelException {
        List<Object> sources = Collections.emptyList();
        try {
            sources = this.getSources();
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
        this.internalUpdate(sources);
    }

    protected abstract void fireComponentAdded(C var1);

    protected abstract void fireComponentRemoved(C var1);

    public void internalUpdate(List<S> sources) throws CloudModelException {
        if (this.isInitialized()) {
            IInternalComponent component;
            ArrayList<S> sourcesTemp = new ArrayList<S>(sources);
            ArrayList<C> componentsTemp = new ArrayList<C>(this.components);
            Iterator sourcesIter = sourcesTemp.iterator();
            block0: while (sourcesIter.hasNext()) {
                Object source = sourcesIter.next();
                Iterator componentsIter = componentsTemp.iterator();
                while (componentsIter.hasNext()) {
                    component = (IInternalComponent)componentsIter.next();
                    if (!component.equalValues(source)) continue;
                    component.internalUpdate(source);
                    sourcesIter.remove();
                    componentsIter.remove();
                    continue block0;
                }
            }
            for (IInternalComponent component2 : componentsTemp) {
                this.getComponents().remove(component2);
                this.fireComponentRemoved(component2);
            }
            for (Object source : sourcesTemp) {
                component = this.createComponent(source);
                this.getComponents().add(component);
                this.fireComponentAdded(component);
            }
        } else {
            ArrayList<C> tempComponents = new ArrayList<C>();
            for (S source : sources) {
                tempComponents.add(this.createComponent(source));
            }
            this.components = tempComponents;
        }
        super.update();
    }
}

