/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views.actions;

import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.presenter.CreateStorageBackupRequest;
import com.clustercontrol.cloud.presenter.ICloudStorage;
import com.clustercontrol.cloud.ui.dialogs.CreateStorageBackupDialog;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

public class BackupStorageAction
extends SingleSelectionActionEx {
    public static final String ID = "com.clustercontrol.cloud.ui.views.actions.BackupStorage";
    private MessageManager messages = MessageManager.getInstance("messages");
    private String msgBackupStorageConfirm = this.messages.getString("message.confirm_some_action_to_something", new Object[]{"word.storage_backup", "word.create"});
    private String msgBackupStorageResult = this.messages.getString("message.result_some_action_to_something", new Object[]{"word.storage_backup", "word.create"});

    @Override
    protected void invoke(IAction action) throws InvocationException {
        ICloudStorage storage = (ICloudStorage)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        CreateStorageBackupDialog dialog = new CreateStorageBackupDialog(this.viewPart.getSite().getShell(), storage);
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.msgBackupStorageConfirm)) {
                CreateStorageBackupRequest request = new CreateStorageBackupRequest();
                request.setSnapshotName(dialog.getName());
                request.setDescription(dialog.getDescription());
                request.setStorageId(storage.getStorageId());
                storage.getCloudStorageManager().getCloudComputeService().getStorageBackupManager().backupCloudStorage(request);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgBackupStorageResult);
            } else {
                return;
            }
        }
    }
}

