/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.base.resources;

import java.util.List;

public interface CloudResourceProvider {
	public static final String filter_name_zone = "zone";
	public static final String filter_name_category = "category";
	public static final String filter_value_category_official = "official";
	public static final String filter_value_category_my = "my";
	
	List<Zone> getZones(String regionName);
	List<ServiceOffering> getServiceOfferings();
	List<DiskOffering> getDiskOfferings();
	List<Template> getTemplates(String regionName, List<Filter> filters);
	List<Snapshot> getSnapshots(String regionName, List<Filter> filters);
	List<Network> getNetworksByRegion(String regionName);
	List<String> getAllRegion();
	List<SecurityGroup> getSecurityGroups(String regionName);
}