/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.base.ui.dialogs;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.ValidateException;
import com.clustercontrol.cloud.commons.util.annotation.RequiredSelect;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.presenter.ICloudStorage;
import com.clustercontrol.util.Messages;

public class AttachStorageFromStorageDialog extends Dialog {
	public static class VolumeProvider {
		private VolumeContentProvider vcp;
		private VolumeLabelProvider vlp;
		
		public VolumeProvider(){
			this.vcp = new VolumeContentProvider();
			this.vlp = new VolumeLabelProvider();
		}
		
		public class VolumeContentProvider implements IStructuredContentProvider {
			@Override
			public Object[] getElements(Object inputElement) {
				return ((java.util.List<?>)inputElement).toArray();
			}
			@Override
			public void dispose() {
			}
			@Override
			public void inputChanged(Viewer viewer,	Object oldInput, Object newInput) {
			}
		}
		
		public class VolumeLabelProvider extends LabelProvider implements ITableLabelProvider {
			@Override
			public String getColumnText(Object element, int columnIndex) {
				ICloudStorage storage = (ICloudStorage)element;
				switch(columnIndex) {
					case 0:
						return storage.getStorageId();
					case 1:
						return storage.getStorageAttachment() != null ? storage.getStorageAttachment().getDevice() : "";
					case 2:
						return storage.getSnapshotId() != null ? storage.getSnapshotId(): "";
					case 3:
						return storage.getSize() != null ? String.valueOf(storage.getSize()): "";
					case 4:
						return storage.getFlavor();
					}
				return null;
			}
			@Override
			public Image getColumnImage(Object element, int columnIndex) {
				return null;
			}
		}

		public VolumeContentProvider getVolumeContentProvider(){
			return this.vcp;
		}

		public VolumeLabelProvider getVolumeLabelProvider(){
			return this.vlp;
		}
	}
	
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	
	private String strSeparator = messages.getString("caption.title_separator");
	private String strZone = messages.getString("word.zone");
	private String strInstance = messages.getString("word.instance");
	private String strStorageType = messages.getString("word.storage_type");
	private String strVolumeSize = messages.getString("word.volume_size");
	private String strSnapshot = messages.getString("word.snapshot");
	private String strDevice = messages.getString("word.device");
	private String strStorageId = messages.getString("word.storage_id");
	private String strSnapshotId = messages.getString("word.snapshot_id");
	private String strSize = messages.getString("size");
	private String strAttachStorageDialog = messages.getString("caption.attach_storage_dialog");
//	private String msgMustFullyInput = messages.getString("message.must_fully_input");
	

	private Text zone;
	@RequiredSelect("strInstance")
	private Combo comboInstance;
	private Table tblVolume;
	private TableViewer tableViewer;
//	private Text device;

	private ICloudStorage storage;
	private String instanceId;
//	private String deviceName;

	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public AttachStorageFromStorageDialog(Shell parentShell, ICloudStorage storage) {
		super(parentShell);
		this.storage = storage;
	}

	public String getInstanceId(){
		return instanceId;
	}

//	public String getDeviceName(){
//		return deviceName;
//	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		storage.update();
		
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(5, false);
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);
		
		Label lblZone = new Label(container, SWT.NONE);
		lblZone.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblZone.setText(strZone + strSeparator);
		
		zone = new Text(container, SWT.READ_ONLY);
		zone.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		zone.setText(storage.getZone());
		
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		
		Label lblInstance = new Label(container, SWT.NONE);
		lblInstance.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblInstance.setText(strInstance + strSeparator);
		
		comboInstance = new Combo(container, SWT.READ_ONLY);
		comboInstance.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				ICloudInstance instance = (ICloudInstance)comboInstance.getData(comboInstance.getText());
				instanceId = instance.getInstanceId();

				List<ICloudStorage> storages = new ArrayList<ICloudStorage>();
				for (ICloudStorage s: storage.getCloudStorageManager().getCloudStorages()) {
					if (instanceId.equals(s.getStorageAttachment() == null ? null: s.getStorageAttachment().getInstanceId())) {
						storages.add(s);
					}
				}
				tableViewer.setInput(storages);
//				AttachStorageFromStorageDialog.this.updateSelection(storages);
			}
		});
		GridData gd_instance = new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1);
		gd_instance.widthHint = 199;
		comboInstance.setLayoutData(gd_instance);

		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		
		Label lblVolumeType = new Label(container, SWT.NONE);
		lblVolumeType.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblVolumeType.setText(strStorageType + strSeparator);
		
		Text volumeType = new Text(container, SWT.READ_ONLY);
		GridData gd_volumeType = new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1);
		gd_volumeType.widthHint = 226;
		volumeType.setLayoutData(gd_volumeType);
		volumeType.setText(messages.getString(storage.getFlavor().toString()));
		
		Label lblVolumeSize = new Label(container, SWT.NONE);
		GridData gd_lblVolumeSize = new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1);
		gd_lblVolumeSize.widthHint = 83;
		lblVolumeSize.setLayoutData(gd_lblVolumeSize);
		lblVolumeSize.setText(strVolumeSize + strSeparator);
		
		Text volumeSize = new Text(container, SWT.READ_ONLY);
		GridData gd_volumeSize = new GridData(SWT.LEFT, SWT.RIGHT, false, false, 1, 1);
		gd_volumeSize.widthHint = 134;
		volumeSize.setLayoutData(gd_volumeSize);
		
		volumeSize.setText(storage.getSize().toString());
		
		Label lblGib = new Label(container, SWT.NONE);
		GridData gd_lblGib = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_lblGib.widthHint = 55;
		lblGib.setLayoutData(gd_lblGib);
		lblGib.setText("GiB");
		
		Label lblSnapshot = new Label(container, SWT.NONE);
		lblSnapshot.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblSnapshot.setText(strSnapshot + strSeparator);
		
		Combo snapshot = new Combo(container, SWT.NONE);
		snapshot.setEnabled(false);
		snapshot.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1));
		new Label(container, SWT.NONE);
		
		if(storage.getSnapshotId() != null){
			snapshot.setText(storage.getSnapshotId());
		}
		
//		Label lblDevice = new Label(container, SWT.NONE);
//		lblDevice.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
//		lblDevice.setText(strDevice);
		
//		device = new Combo(container, SWT.READ_ONLY);
//		device = new Text(container, SWT.BORDER);
//		GridData gd_device = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
//		gd_device.widthHint = 242;
//		device.setLayoutData(gd_device);
//		new Label(container, SWT.NONE);
//		new Label(container, SWT.NONE);
//		new Label(container, SWT.NONE);
//		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		
		tblVolume = new Table(container, SWT.BORDER | SWT.FULL_SELECTION | SWT.VIRTUAL);
		tblVolume.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				tblVolume.select(-1);
			}
		});
		tblVolume.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 5, 1));
		tblVolume.setHeaderVisible(true);
		tblVolume.setLinesVisible(true);
		
		TableColumn tblclmnType = new TableColumn(tblVolume, SWT.NONE);
		tblclmnType.setWidth(100);
		tblclmnType.setText(strStorageId);
		
		TableColumn tblclmnDevice = new TableColumn(tblVolume, SWT.NONE);
		tblclmnDevice.setWidth(100);
		tblclmnDevice.setText(strDevice);
		
		TableColumn tblclmnSnapshotId = new TableColumn(tblVolume, SWT.NONE);
		tblclmnSnapshotId.setWidth(100);
		tblclmnSnapshotId.setText(strSnapshotId);
		
		TableColumn tblclmnSize = new TableColumn(tblVolume, SWT.NONE);
		tblclmnSize.setWidth(100);
		tblclmnSize.setText(strSize);
		
		TableColumn tblclmnVolumeType = new TableColumn(tblVolume, SWT.NONE);
		tblclmnVolumeType.setWidth(100);
		tblclmnVolumeType.setText(strStorageType);
		
//		TableColumn tblclmnIops = new TableColumn(tblVolume, SWT.NONE);
//		tblclmnIops.setWidth(100);
//		tblclmnIops.setText(bundle_dialog_label.getString("dialog.attach_storage.column.iops"));
//		
//		TableColumn tblclmnDeleteOnTermination = new TableColumn(tblVolume, SWT.NONE);
//		tblclmnDeleteOnTermination.setWidth(142);
//		tblclmnDeleteOnTermination.setText(bundle_dialog_label.getString("dialog.attach_storage.column.delete_on_termination"));

		tableViewer = new TableViewer(tblVolume);
		VolumeProvider vp = new VolumeProvider();
		tableViewer.setContentProvider(vp.getVolumeContentProvider());
		tableViewer.setLabelProvider(vp.getVolumeLabelProvider());

		storage.getCloudStorageManager().getCloudComputeService().getInstanceManager().update();
		for(ICloudInstance instance: storage.getCloudStorageManager().getCloudComputeService().getInstanceManager().getCloudInstances()){
			if (instance.getZone().equals(storage.getZone()) && !instance.getRegistState().equals(ICloudInstance.RegistStateType.deleted.name())) {
				comboInstance.setData(instance.getInstanceId(), instance);
				comboInstance.add(instance.getInstanceId());
			}
		}
		if (comboInstance.getItemCount() > 0) {
			comboInstance.select(0);
		}

		return area;
	}

//	@SuppressWarnings("unchecked")
//	protected void updateSelection(Object o){
//		tableViewer.setInput(o);
//		
//		device.removeAll();
//		for(AvailableDevice ad: AvailableDevice.values()){
//			Boolean b = true;
//			for(ICloudStorage storage: (List<ICloudStorage>)o){
//				if(ad.toString().equals(storage.getStorageAttachment()!= null ? storage.getStorageAttachment().getDevice(): null)){
//					b = false;
//					break;
//				}
//			}
//			if(b){
//				device.add(ad.toString());
//			}
//		}
//		if (device.getItemCount() > 0) {
//			device.select(0);
//		}
//	}
	
	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(800, 600);
	}

	@Override
	protected void okPressed() {
		try{
			ControlUtil.validate(this);
		} catch(ValidateException e){
			MessageDialog.openError(null, Messages.getString("failed"), e.getMessage());
			return;
		} catch(Exception e){
			throw new RuntimeException(e);
		}

		
//		deviceName = device.getText();
		
		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(strAttachStorageDialog);
	}
}
