/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.base.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.cloudn.base.commons.util.CloudnConstants;
import com.clustercontrol.cloud.cloudn.base.commons.util.ControlUtilEx;
import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.cloudn.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.cloudn.base.resources.Filter;
import com.clustercontrol.cloud.cloudn.base.resources.SecurityGroup;
import com.clustercontrol.cloud.cloudn.base.resources.ServiceOffering;
import com.clustercontrol.cloud.cloudn.base.resources.Template;
import com.clustercontrol.cloud.cloudn.base.resources.Zone;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.ValidateException;
import com.clustercontrol.cloud.commons.util.annotation.RelationalRequiredSelect;
import com.clustercontrol.cloud.commons.util.annotation.RequiredInput;
import com.clustercontrol.cloud.commons.util.annotation.RequiredSelect;
import com.clustercontrol.cloud.presenter.CreateCloudInstanceRequest;
import com.clustercontrol.cloud.presenter.ICloudTemplate;
import com.clustercontrol.cloud.presenter.ICloudTemplateManager;
import com.clustercontrol.cloud.presenter.TemplateJobsArgument;
import com.clustercontrol.cloud.resources.Tag;
import com.clustercontrol.cloud.ui.dialogs.EditTemplateJobArgumentDialog;
import com.clustercontrol.util.Messages;

public class CreateInstanceDialog_FLAT extends Dialog implements CloudnConstants {
	public static class Model extends CreateCloudInstanceRequest {
		private String templateId;
		private List<TemplateJobsArgument> arguments;
		private Boolean isTemplateUsed = false;
		private String group;
		private List<String> securityGroups;
		private Boolean attachingDisk;
		
		public String getTemplateId() {return templateId;}
		public void setTemplateId(String templateId) {this.templateId = templateId;}
		public List<TemplateJobsArgument> getArguments() {return arguments;}
		public void setArguments(List<TemplateJobsArgument> arguments) {this.arguments = arguments;}
		public Boolean isTemplateUsed() {return isTemplateUsed;}
		public void setIsTemplateUsed(Boolean isTemplateUsed) {this.isTemplateUsed = isTemplateUsed;}
		public String getGroup() {return group;}
		public void setGroup(String group) {this.group = group;}
		public List<String> getSecurityGroups() {return securityGroups;}
		public void setSecurityGroups(List<String> securityGroups) {this.securityGroups = securityGroups;}
		public Boolean getAttachingDisk() {return attachingDisk;}
		public void setAttachingDisk(Boolean attachingDisk) {this.attachingDisk = attachingDisk;}
	}
	
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	
	private String strSeparator = messages.getString("caption.title_separator");
	private String strNodeInfo = messages.getString("word.node_info");
	private String strFacilityId = messages.getString("word.facility_id");
	private String strNodeReplaceDescription = messages.getString("caption.node_replace_description");
	private String strFacilityName = messages.getString("word.facility_name");
	private String strDescription = messages.getString("word.description");
	private String strNodeName = messages.getString("word.node_name");
	private String strInstanceInfo = messages.getString("word.instance_info");
	private String strZone = messages.getString("word.zone");
	private String strSecurityGroup = messages.getString("word.security_group");
	private String strSelectSecurityGroup = messages.getString("caption.edit_security_groups");
	private String strVmi = messages.getString("word.virtual_machine_image");
	private String strRefer = messages.getString("word.refer");
	private String strUseTemplate = messages.getString("caption.use_subjects", new Object[]{"word.template"});
	private String strTemplate = messages.getString("word.template");
	private String strEditArgument = messages.getString("caption.edit_argument");
	private String strAttachingDisk = messages.getString("caption.attaching_disk");
	private String strInstanceFlavor = messages.getString("word.instance_type");
	private String strCreateInstanceDialog = messages.getString("caption.create_instance_dialog");
	private String strGroup = messages.getString("word.group");
	private String strEditTags = messages.getString("caption.edit_tags");
	private String msgTemplateDoesNotExists = messages.getString("message.template_does_not_exists");


	private Shell shell;

	@RequiredInput("strFacilityId")
	private Text txtFacilityId;
	private Button btnReplaceNode;
	@RequiredInput("strFacilityName")
	private Text txtFacilityName;
	private Text txtDescription;
	@RequiredInput("strNodeName")
	private Text txtNodeName;
	@RequiredSelect("strZone")
	private Combo cmbZone;
	private Text txtVMI;
	@RelationalRequiredSelect(name="btnUseTemplate", value="strTemplate")
	private Combo cmbTemplate;
	private Button btnUseTemplate;
	
	private Button btnSelectVMI;
	private Button btnEditArgument;

	private Button btnSelectSecurityGroups;
	private Button btnEditTags;

	@RequiredSelect("strFlavor")
	private Combo cmbFlavor;
	private Text txtGroup;
	
	private Button btnAttachingDisk;
	
	private CloudResourceProvider provider;
	private String region = CloudnConstants.DEFAULT_REGION;
	
//	private Model input = null;
	private Model output = new Model();
	
	private List<Tag> tags = new ArrayList<>();
	private List<SecurityGroup> securityGroups = new ArrayList<SecurityGroup>();
	
	private ICloudTemplateManager cloudTemplateManager;
	
	private Label lblZone;
	private Label lblVMI;
	private Label lblUseTemplate;
	private Label lblTemplate;
	private Label lblGroup;
	private Label lblFlavor;
	private Label lblAttachingDisk;
	
	public void setCloudTemplateManager(ICloudTemplateManager cloudTemplateManager) {
		this.cloudTemplateManager = cloudTemplateManager;
	}
	private List<TemplateJobsArgument> arguments;
	
	public static interface IDialogBehavior{
		void setup(DialogControlContainer container);
	}
	
	public static class DialogBehavior implements IDialogBehavior{
		@Override
		public void setup(DialogControlContainer container) {}
	}

	private IDialogBehavior behavior = new DialogBehavior();
	
	public void setBehavior(IDialogBehavior behavior) {
		this.behavior = behavior;
	}

	public static class DialogControlContainer{
		private Text txtFacilityId;
		private Button btnReplaceNode;
		private Text txtFacilityName;
		private Text txtDescription;
		private Text txtNodeName;
		private Combo cmbZone;
		private Text txtVMI;
		private Combo cmbTemplate;
		private Button btnUseTemplate;
		private Button btnSelectVMI;
		private Button btnEditArgument;
		private Button btnEditTags;
		private Combo cmbFlavor;
		private Text txtGroup;
		private Label lblVMI;
		private Label lblTemplate;
		private Label lblAttachingDisk;
		private Button btnSelectSecurityGroups;
		private Button btnAttachingDisk;
		
		public DialogControlContainer(
			Text txtFacilityId,
			Button btnReplaceNode,
			Text txtFacilityName,
			Text txtDescription,
			Text txtNodeName,
			Combo cmbZone,
			Text txtVMI,
			Combo cmbTemplate,
			Button btnUseTemplate,
			Button btnSelectVMI,
			Button btnEditArgument,
			Button btnEditTags,
			Combo cmbFlavor,
			Text txtGroup,
			Label lblVMI,
			Label lblTemplate,
			Label lblAttachingDisk,
			Button btnSelectSecurityGroups,
			Button btnAttachingDisk
		){
			this.txtFacilityId = txtFacilityId;
			this.btnReplaceNode = btnReplaceNode;
			this.txtFacilityName = txtFacilityName;
			this.txtDescription = txtDescription;
			this.txtNodeName = txtNodeName;
			this.cmbZone = cmbZone;
			this.txtVMI = txtVMI;
			this.cmbTemplate = cmbTemplate;
			this.btnUseTemplate = btnUseTemplate;
			this.btnSelectVMI = btnSelectVMI;
			this.btnEditArgument = btnEditArgument;
			this.btnEditTags = btnEditTags;
			this.cmbFlavor = cmbFlavor;
			this.txtGroup = txtGroup;
			this.lblVMI = lblVMI;
			this.lblTemplate = lblTemplate;
			this.lblAttachingDisk = lblAttachingDisk;
			this.btnSelectSecurityGroups = btnSelectSecurityGroups;
			this.btnAttachingDisk = btnAttachingDisk;
		}
		
		public Text getFacilityId() {return txtFacilityId;}
		public Button getBtnReplaceNode() {return btnReplaceNode;}
		public Text getFacilityName() {return txtFacilityName;}
		public Text getDescription() {return txtDescription;}
		public Text getNodeName() {return txtNodeName;}
		public Combo getCmbZone() {return cmbZone;}
		public Text getTxtVMI() {return txtVMI;}
		public Combo getCmbTemplate() {return cmbTemplate;}
		public Button getBtnUseTemplate() {return btnUseTemplate;}
		public Button getBtnSelectVMI() {return btnSelectVMI;}
		public Button getBtnEditArgument() {return btnEditArgument;}
		public Button getBtnEditTags() {return btnEditTags;}
		public Combo getCmbFlavor() {return cmbFlavor;}
		public Text getTxtGroup() {return txtGroup;}
		public Label getLblVMI() {return lblVMI;}
		public Label getLblTemplate() {return lblTemplate;}
		public Label getLblAttachingDisk() {return lblAttachingDisk;}
		public Button getBtnSelectSecurityGroups() {return btnSelectSecurityGroups;}
		public Button getBtnAttachingDisk() {return btnAttachingDisk;}
	}
	
	
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public CreateInstanceDialog_FLAT(Shell parentShell){
		super(parentShell);
		this.shell = parentShell;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(1, false);
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);

		Group grpNodeInfo = new Group(container, SWT.NONE);
		GridLayout gl_grpNodeInfo = new GridLayout(2, false);
		gl_grpNodeInfo.verticalSpacing = 9;
		gl_grpNodeInfo.horizontalSpacing = 15;
		grpNodeInfo.setLayout(gl_grpNodeInfo);
		grpNodeInfo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 5, 1));

		Label lblid = new Label(grpNodeInfo, SWT.RIGHT);
		lblid.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));

		txtFacilityId = new Text(grpNodeInfo, SWT.BORDER);
		txtFacilityId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		new Label(grpNodeInfo, SWT.NONE);
		
		btnReplaceNode = new Button(grpNodeInfo, SWT.CHECK);
		
		Label lblFacilityName = new Label(grpNodeInfo, SWT.RIGHT);
		lblFacilityName.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		
		txtFacilityName = new Text(grpNodeInfo, SWT.BORDER);
		txtFacilityName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		
		Label lblDescription = new Label(grpNodeInfo, SWT.RIGHT);
		lblDescription.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		
		txtDescription = new Text(grpNodeInfo, SWT.BORDER);
		txtDescription.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		
		Label lblNodeName = new Label(grpNodeInfo, SWT.RIGHT);
		lblNodeName.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		
		txtNodeName = new Text(grpNodeInfo, SWT.BORDER);
		GridData gd_nodeName = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_nodeName.widthHint = 66;
		txtNodeName.setLayoutData(gd_nodeName);
		
		Group grpInstacneInfo = new Group(container, SWT.NONE);
		
		GridLayout gl_grpInstacneInfo = new GridLayout(3, false);
		gl_grpInstacneInfo.verticalSpacing = 9;
		gl_grpInstacneInfo.horizontalSpacing = 15;
		grpInstacneInfo.setLayout(gl_grpInstacneInfo);
		GridData gd_grpInstacneInfo = new GridData(SWT.FILL, SWT.CENTER, false, false, 5, 1);
		gd_grpInstacneInfo.heightHint = 350;
		grpInstacneInfo.setLayoutData(gd_grpInstacneInfo);
		
		lblZone = new Label(grpInstacneInfo, SWT.NONE);
		lblZone.setAlignment(SWT.RIGHT);
		lblZone.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		
		cmbZone = new Combo(grpInstacneInfo, SWT.READ_ONLY);
		cmbZone.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		
		lblVMI = new Label(grpInstacneInfo, SWT.NONE);
		lblVMI.setAlignment(SWT.RIGHT);
		lblVMI.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		
		txtVMI = new Text(grpInstacneInfo, SWT.BORDER | SWT.READ_ONLY);
		GridData gd_txtVMI = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_txtVMI.widthHint = 100;
		txtVMI.setLayoutData(gd_txtVMI);
		
		btnSelectVMI = new Button(grpInstacneInfo, SWT.NONE);
		btnSelectVMI.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
	
		lblUseTemplate = new Label(grpInstacneInfo, SWT.NONE);
		lblUseTemplate.setAlignment(SWT.RIGHT);
		lblUseTemplate.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		
		btnUseTemplate = new Button(grpInstacneInfo, SWT.CHECK);
		btnUseTemplate.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnUseTemplate.setAlignment(SWT.RIGHT);
		
		new Label(grpInstacneInfo, SWT.NONE);
		
		lblTemplate = new Label(grpInstacneInfo, SWT.NONE);
		lblTemplate.setEnabled(false);
		lblTemplate.setAlignment(SWT.RIGHT);
		lblTemplate.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		
		cmbTemplate = new Combo(grpInstacneInfo, SWT.BORDER | SWT.READ_ONLY);
		cmbTemplate.setEnabled(false);
		GridData gd_cmbTemplate = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_cmbTemplate.widthHint = 100;
		cmbTemplate.setLayoutData(gd_cmbTemplate);
						
		btnEditArgument = new Button(grpInstacneInfo, SWT.NONE);
		btnEditArgument.setEnabled(false);
		btnEditArgument.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		
		new Label(grpInstacneInfo, SWT.NONE);
		new Label(grpInstacneInfo, SWT.NONE);
		new Label(grpInstacneInfo, SWT.NONE);
		
		lblFlavor = new Label(grpInstacneInfo, SWT.NONE);
		lblFlavor.setAlignment(SWT.RIGHT);
		lblFlavor.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));

		cmbFlavor = new Combo(grpInstacneInfo, SWT.BORDER);
		GridData gd_cmbFlavor = new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1);
		gd_cmbFlavor.widthHint = 100;
		cmbFlavor.setLayoutData(gd_cmbFlavor);

		lblGroup = new Label(grpInstacneInfo, SWT.NONE);
		lblGroup.setAlignment(SWT.RIGHT);
		lblGroup.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		
		txtGroup = new Text(grpInstacneInfo, SWT.BORDER);
		txtGroup.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));

		lblAttachingDisk = new Label(grpInstacneInfo, SWT.NONE);
		lblAttachingDisk.setAlignment(SWT.RIGHT);
		lblAttachingDisk.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		
		btnAttachingDisk = new Button(grpInstacneInfo, SWT.CHECK);
		btnAttachingDisk.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnAttachingDisk.setAlignment(SWT.RIGHT);
		new Label(grpInstacneInfo, SWT.NONE);
		
		new Label(grpInstacneInfo, SWT.NONE);
		new Label(grpInstacneInfo, SWT.NONE);

		btnSelectSecurityGroups = new Button(grpInstacneInfo, SWT.NONE);
		btnSelectSecurityGroups.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		
		new Label(grpInstacneInfo, SWT.NONE);
		new Label(grpInstacneInfo, SWT.NONE);
		
		btnEditTags = new Button(grpInstacneInfo, SWT.NONE);
		btnEditTags.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		
		
		// リスナ
		{
			cmbZone.addModifyListener(new ModifyListener() {
				public void modifyText(ModifyEvent e) {
					txtVMI.setText("");
					txtVMI.setData(null);
					
					cmbTemplate.removeAll();
					if (btnUseTemplate.getSelection()) {
						for(ICloudTemplate tmpTemplate: cloudTemplateManager.getCloudTemplates()){
							if (tmpTemplate.getRegion().equals(region)
								&& tmpTemplate.getImageId().substring(37).equals(cmbZone.getText())
							) {
								String tmpLabel = tmpTemplate.getTemplateName() + " ( " + tmpTemplate.getTemplateId() + " )";
								cmbTemplate.add(tmpLabel);
								cmbTemplate.setData(tmpLabel, tmpTemplate);
							}
						}
						
						if (cmbTemplate.getItemCount() > 0) {
							cmbTemplate.select(0);
							
							lblTemplate.setEnabled(true);
							cmbTemplate.setEnabled(true);
							btnEditArgument.setEnabled(true);
							lblVMI.setEnabled(false);
							txtVMI.setEnabled(false);
							btnSelectVMI.setEnabled(false);
							txtVMI.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
						} else {
							MessageDialog.openError(null, Messages.getString("failed"), msgTemplateDoesNotExists);
							btnUseTemplate.setSelection(false);
							lblTemplate.setEnabled(false);
							cmbTemplate.setEnabled(false);
							btnEditArgument.setEnabled(false);
							lblVMI.setEnabled(true);
							txtVMI.setEnabled(true);
							btnSelectVMI.setEnabled(true);
						}
					}
					if(!btnUseTemplate.getSelection()){
						txtVMI.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
					}
				}
			});

			btnUseTemplate.addSelectionListener(new SelectionAdapter(){
				public void widgetSelected(SelectionEvent e) {
					if (btnUseTemplate.getSelection()) {
						if (cmbTemplate.getItemCount() == 0) {
							for(ICloudTemplate tmpTemplate: cloudTemplateManager.getCloudTemplates()){
								if (tmpTemplate.getRegion().equals(region)
										&& tmpTemplate.getImageId().substring(37).equals(cmbZone.getText())
									) {
									String tmpLabel = tmpTemplate.getTemplateName() + " ( " + tmpTemplate.getTemplateId() + " )";
									cmbTemplate.add(tmpLabel);
									cmbTemplate.setData(tmpLabel, tmpTemplate);
								}
							}
							if (cmbTemplate.getItemCount() > 0) {
								cmbTemplate.select(0);
							}
						}
						
						if (cmbTemplate.getItemCount() > 0) {
							lblTemplate.setEnabled(true);
							cmbTemplate.setEnabled(true);
							btnEditArgument.setEnabled(true);
							lblVMI.setEnabled(false);
							txtVMI.setEnabled(false);
							btnSelectVMI.setEnabled(false);
							txtVMI.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
						} else {
							MessageDialog.openError(null, Messages.getString("failed"), msgTemplateDoesNotExists);
							btnUseTemplate.setSelection(false);
						}
					} else {
						lblTemplate.setEnabled(false);
						cmbTemplate.setEnabled(false);
						btnEditArgument.setEnabled(false);
						lblVMI.setEnabled(true);
						txtVMI.setEnabled(true);
						btnSelectVMI.setEnabled(true);

						if(txtVMI.getText().equals("")){
							txtVMI.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
						}
					}
				}
			});
			
			btnSelectVMI.addSelectionListener(new SelectionAdapter(){
				@Override
				public void widgetSelected(SelectionEvent e) {
					List<Template> officials = provider.getTemplates(
							region,
							Arrays.asList(
								new Filter(CloudResourceProvider.filter_name_category, CloudResourceProvider.filter_value_category_official),
								new Filter(CloudResourceProvider.filter_name_zone, cmbZone.getText())));
					List<Template> mys = provider.getTemplates(
							region,
							Arrays.asList(
								new Filter(CloudResourceProvider.filter_name_category, CloudResourceProvider.filter_value_category_my),
								new Filter(CloudResourceProvider.filter_name_zone, cmbZone.getText())));
					SelectVMIDialog dialog = new SelectVMIDialog(officials, mys, shell);
					if (dialog.open() == Window.OK) {
						Template output = dialog.getOutput();
						txtVMI.setText(output.getName() + " ( " + output.getId() + " ) ");
						txtVMI.setData(output);
					}
				}
			});
			
			btnEditArgument.addSelectionListener(new SelectionAdapter(){
				@Override
				public void widgetSelected(SelectionEvent e) {
					if(cmbTemplate.getText().equals("")){
						return;
					}
					ICloudTemplate tmpTemplate = (ICloudTemplate)cmbTemplate.getData(cmbTemplate.getText()); 
					if(tmpTemplate == null || tmpTemplate.getLaunchJobId() == null || tmpTemplate.getLaunchJobId().equals("")){
						return;
					}
					EditTemplateJobArgumentDialog dialog = new EditTemplateJobArgumentDialog(shell, cloudTemplateManager.getAccountResource().getAccountResourceId(), tmpTemplate.getTemplateId(), tmpTemplate.getLaunchJobId());
					
					if (dialog.open() == Window.OK) {
						arguments = dialog.getArguments();
					}
				}
			});
			
			btnSelectSecurityGroups.addSelectionListener(new SelectionAdapter(){
				@Override
				public void widgetSelected(SelectionEvent e) {
					ListSelectionDialog<SecurityGroup> dialog = new ListSelectionDialog<SecurityGroup>(shell){
						@Override
						protected String getLabel(SecurityGroup element) {
							return element.getName();
						}
						@Override
						protected List<SecurityGroup> getAllList() {
							return provider.getSecurityGroups(region);
						}
						@Override
						protected String getElementName() {
							return strSecurityGroup;
						}
					};
					if(!securityGroups.isEmpty()){
						dialog.setList(securityGroups);
					}
					if (dialog.open() == Window.OK) {
						securityGroups = dialog.getList();
					}
				}
			});
			
			btnEditTags.addSelectionListener(new SelectionAdapter(){
				@Override
				public void widgetSelected(SelectionEvent e) {
					EditTagsDialog dialog = new EditTagsDialog(shell, tags);
					if (dialog.open() == Window.OK) {
						tags.clear();
						tags.addAll(dialog.getOutput());
					}
				}
			});
		}
				
		// 初期設定
		{
			grpNodeInfo.setText(strNodeInfo + strSeparator);
			lblid.setText(strFacilityId + strSeparator);
			btnReplaceNode.setText(strNodeReplaceDescription);
			lblFacilityName.setText(strFacilityName + strSeparator);
			lblDescription.setText(strDescription + strSeparator);
			lblNodeName.setText(strNodeName + strSeparator);
			grpInstacneInfo.setText(strInstanceInfo);
			lblZone.setText(strZone + strSeparator);
			lblVMI.setText(strVmi + strSeparator);
			btnSelectVMI.setText(strRefer);
			lblTemplate.setText(strTemplate + strSeparator);
			btnEditArgument.setText(strEditArgument);
			lblFlavor.setText(strInstanceFlavor + strSeparator);
			lblUseTemplate.setText(strUseTemplate + strSeparator);
			lblGroup.setText(strGroup + strSeparator);
			lblAttachingDisk.setText(strAttachingDisk + strSeparator);
			btnSelectSecurityGroups.setText(strSelectSecurityGroup);
			btnEditTags.setText(strEditTags);

			lblAttachingDisk.setVisible(false);
			btnAttachingDisk.setVisible(false);
			
			List<Zone> zones = provider.getZones(region);
			for (Zone z: zones) {
				cmbZone.add(z.getName());
			}
			cmbZone.select(0);
			
			List<ServiceOffering> sos = provider.getServiceOfferings();
			for (ServiceOffering so: sos) {
				cmbFlavor.add(so.getName());
			}
			cmbFlavor.select(0);
		}
		
		ControlUtilEx.setRequired(new Control[]{txtFacilityId, txtFacilityName, txtNodeName, txtVMI, cmbFlavor});
		
		{
			behavior.setup(new DialogControlContainer(txtFacilityId, btnReplaceNode, txtFacilityName, txtDescription, txtNodeName, cmbZone, txtVMI, cmbTemplate, btnUseTemplate, btnSelectVMI, btnEditArgument, btnEditTags, cmbFlavor, txtGroup, lblVMI, lblTemplate, lblAttachingDisk, btnSelectSecurityGroups, btnAttachingDisk));
		}
		
		// ラベルの位置調整
		container.layout();
		Control[] labels = new Control[]{lblid, lblFacilityName, lblDescription, lblNodeName, lblZone, lblVMI, lblUseTemplate, lblTemplate, lblFlavor, lblGroup, lblAttachingDisk};
		int maxWidth = 0;
		for (Control l: labels) {
			Point p = l.getSize();
			maxWidth = Math.max(maxWidth, p.x);
		}
		for (Control l: labels) {
			((GridData)l.getLayoutData()).widthHint = maxWidth;
		}
		grpNodeInfo.layout(true);
		grpInstacneInfo.layout(true);
		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 690);
	}

	@Override
	protected void okPressed() {
		try{
			ControlUtil.validate(this);
		} catch(ValidateException e){
			MessageDialog.openError(null, Messages.getString("failed"), e.getMessage());
			return;
		} catch(Exception e){
			throw new RuntimeException(e);
		}
		if (!btnUseTemplate.getSelection() && txtVMI.getText().equals("")){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					messages.getString("validation.required_input.message", new String[]{strVmi}));
			return;
		}
		
		output.setFacilityId(txtFacilityId.getText());
		output.setFacilityName(txtFacilityName.getText());
		output.setDescription(txtDescription.getText());
		output.setNodeName(txtNodeName.getText());
		output.setReplaceNode(btnReplaceNode.getSelection());
		
		if (!btnUseTemplate.getSelection()) {
			output.setImageId(((Template)txtVMI.getData()).getId());
			output.templateId = null;
		}
		else {
			output.templateId = ((ICloudTemplate)cmbTemplate.getData(cmbTemplate.getText())).getTemplateId();
			if(arguments != null && arguments.size() > 0){
				output.arguments = arguments;
			}
			output.isTemplateUsed = true;
		}
		
		output.setFlavor(cmbFlavor.getText());
		output.setZone(cmbZone.getText());
		output.setTags(tags);
		
		output.setGroup(txtGroup.getText());
		if(!securityGroups.isEmpty()){
			List<String> strSecurityGroups = new ArrayList<>();
			for(SecurityGroup securityGroup: securityGroups){
				strSecurityGroups.add(securityGroup.getName());
			}
			output.setSecurityGroups(strSecurityGroups);
		}
		
		output.setAttachingDisk(btnAttachingDisk.getSelection());
		
		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(strCreateInstanceDialog);
	}

//	public void setInput(Model input) {
//		assert input != null;
//		this.input = input;
//	}

	public CreateInstanceDialog_FLAT.Model getOutput() {
		return output;
	}

	public void setCloudInfoProvider(CloudResourceProvider provider) {
		this.provider = provider;
	}

	public void setRegion(String region) {
		this.region = region;
	}
	public void setSecurityGroups(List<SecurityGroup> securityGroups) {this.securityGroups = securityGroups;}
}
