/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.base.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.cloudn.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.cloudn.base.resources.Template;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.ValidateException;
import com.clustercontrol.cloud.commons.util.annotation.RequiredInput;
import com.clustercontrol.cloud.commons.util.annotation.RequiredSelect;
import com.clustercontrol.cloud.presenter.CreateCloudTemplateRequest;
import com.clustercontrol.util.Messages;

public class CreateTemplateDialog extends Dialog {
	
	public interface IDialogBehavior{
		void setup(DialogControlContainer container);
	}
	
	public static class DialogBehavior implements IDialogBehavior{
		@Override
		public void setup(final DialogControlContainer container) {}
	}

	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	
	private String strSeparator = messages.getString("caption.title_separator");
	private String strTemplateName = messages.getString("word.template_name");
	private String strLaunchJobId = messages.getString("word.launch_job_id");
	private String strStartJobId = messages.getString("word.start_job_id");
	private String strStopJobId = messages.getString("word.stop_job_id");
	private String strRegion = messages.getString("word.region");
	private String strZone = messages.getString("word.zone");
	private String strVmi = messages.getString("word.virtual_machine_image");
	private String strRefer = messages.getString("word.refer");
	private String strTemplateId = messages.getString("word.template_id");
	private String strCreateTemplateDialog = messages.getString("caption.create_template_dialog");

	
	@SuppressWarnings("unused")
	private Shell shell;

	@RequiredSelect("strRegion")
	private Combo cmbRegion;
	@RequiredSelect("strZone")
	private Combo cmbZone;
	@RequiredInput("strTemplate")
	private Text txtTemplateId;
	@RequiredInput("strTemplateName")
	private Text txtTemplateName;
	@RequiredInput("strVmi")
	private Text txtVmi;
	private Combo cmbLaunchJobId;
	private Combo cmbStartJobId;
	private Combo cmbStopJobId;
	
	@SuppressWarnings("unused")
	private CloudResourceProvider provider;

	private IDialogBehavior behavior = new DialogBehavior();

	private CreateCloudTemplateRequest output = new CreateCloudTemplateRequest();
	
	public static class DialogControlContainer{
		private Button btnSelectVmi;
		private Combo cmbRegion;
		private Combo cmbZone;
		private Text txtTemplateId;
		private Text txtTemplateName;
		private Text txtVmi;
		private Combo cmbLaunchJobId;
		private Combo cmbStartJobId;
		private Combo cmbStopJobId;
		public DialogControlContainer(Button btnSelectVmi, 
				Combo cmbRegion, 
				Combo cmbZone,
				Text txtTemplateId,
				Text txtTemplateName,
				Text txtVmi,
				Combo cmbLaunchJobId,
				Combo cmbStartJobId,
				Combo cmbStopJobId){
			this.btnSelectVmi = btnSelectVmi;
			this.cmbRegion = cmbRegion;
			this.cmbZone = cmbZone;
			this.txtTemplateId = txtTemplateId;
			this.txtTemplateName = txtTemplateName;
			this.txtVmi = txtVmi;
			this.cmbLaunchJobId = cmbLaunchJobId;
			this.cmbStartJobId = cmbStartJobId;
			this.cmbStopJobId = cmbStopJobId;
		}
		public Button getBtnSelectVmi() {return btnSelectVmi;}
		public Combo getCmbRegion() {return cmbRegion;}
		public Combo getCmbZone() {return cmbZone;}
		public Text getTxtTemplateId() {return txtTemplateId;}
		public Text getTxtTemplateName() {return txtTemplateName;}
		public Text getTxtVmi() {return txtVmi;}
		public Combo getCmbLaunchJobId() {return cmbLaunchJobId;}
		public Combo getCmbStartJobId() {return cmbStartJobId;}
		public Combo getCmbStopJobId() {return cmbStopJobId;}
	}
	
	
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public CreateTemplateDialog(Shell parentShell) {
		super(parentShell);
		this.shell = parentShell;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.FILL);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(3, false);
		gl_container.verticalSpacing = 15;
		container.setLayout(gl_container);
		GridData gd_container = new GridData(SWT.FILL, SWT.FILL, true, false);
		gd_container.verticalAlignment = SWT.FILL;
		gd_container.horizontalAlignment = SWT.FILL;
		container.setLayoutData(gd_container);
				
		Label lblRegion = new Label(container, SWT.RIGHT);
		lblRegion.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblRegion.setText(strRegion + strSeparator);

		cmbRegion = new Combo(container, SWT.READ_ONLY);
		cmbRegion.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));

		Label lblZone = new Label(container, SWT.RIGHT);
		lblZone.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblZone.setText(strZone + strSeparator);

		cmbZone = new Combo(container, SWT.READ_ONLY);
		cmbZone.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));

		Label lblTemplateId = new Label(container, SWT.RIGHT);
		lblTemplateId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblTemplateId.setText(strTemplateId + strSeparator);

		txtTemplateId = new Text(container, SWT.BORDER);
		txtTemplateId.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
				
		Label lblTemplateName = new Label(container, SWT.RIGHT);
		lblTemplateName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblTemplateName.setText(strTemplateName + strSeparator);
		
		txtTemplateName = new Text(container, SWT.BORDER);
		txtTemplateName.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
	
		Label lblAmi = new Label(container, SWT.RIGHT);
		lblAmi.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblAmi.setText(strVmi + strSeparator);

		txtVmi = new Text(container, SWT.BORDER | SWT.READ_ONLY);
		txtVmi.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));

		Button btnSelectVmi = new Button(container, SWT.NONE);
		btnSelectVmi.setText(strRefer);
		btnSelectVmi.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, true, 1, 1));

		Label lblLaunchJobId = new Label(container, SWT.RIGHT);
		lblLaunchJobId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblLaunchJobId.setText(strLaunchJobId + strSeparator);

		cmbLaunchJobId = new Combo(container, SWT.READ_ONLY);
		GridData gd_launchJobId = new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1);
		gd_launchJobId.widthHint = 100;
		cmbLaunchJobId.setLayoutData(gd_launchJobId);

		Label lblStartJobId = new Label(container, SWT.RIGHT);
		lblStartJobId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblStartJobId.setText(strStartJobId + strSeparator);

		cmbStartJobId = new Combo(container, SWT.READ_ONLY);
		GridData gd_startJobId = new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1);
		gd_startJobId.widthHint = 100;
		cmbStartJobId.setLayoutData(gd_startJobId);

		Label lblStopJobId = new Label(container, SWT.RIGHT);
		lblStopJobId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblStopJobId.setText(strStopJobId + strSeparator);

		cmbStopJobId = new Combo(container, SWT.READ_ONLY);
		GridData gd_stopJobId = new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1);
		gd_stopJobId.widthHint = 100;
		cmbStopJobId.setLayoutData(gd_stopJobId);

		behavior.setup(new DialogControlContainer(btnSelectVmi, cmbRegion, cmbZone, txtTemplateId, txtTemplateName, txtVmi, cmbLaunchJobId, cmbStartJobId, cmbStopJobId));

		ControlUtil.setRequired(new Control[]{txtTemplateId, txtTemplateName, txtVmi});

		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 480);
	}

	@Override
	protected void okPressed() {
		try{
			ControlUtil.validate(this);
		} catch(ValidateException e){
			MessageDialog.openError(null, Messages.getString("failed"), e.getMessage());
			return;
		} catch(Exception e){
			throw new RuntimeException(e);
		}

		
		output.setRegion((String)cmbRegion.getData(cmbRegion.getText()));
		output.setTemplateId(txtTemplateId.getText());
		output.setTemplateName(txtTemplateName.getText().equals("")? null : txtTemplateName.getText());
		output.setImageId(((Template)txtVmi.getData()).getId());
		output.setLaunchJobId(cmbLaunchJobId.getText().equals("")? null : (String)cmbLaunchJobId.getData(cmbLaunchJobId.getText()));
		output.setStartJobId(cmbStartJobId.getText().equals("")? null : (String)cmbStartJobId.getData(cmbStartJobId.getText()));
		output.setStopJobId(cmbStopJobId.getText().equals("")? null : (String)cmbStopJobId.getData(cmbStopJobId.getText()));

		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(strCreateTemplateDialog);
	}

	public CreateCloudTemplateRequest getOutput() {
		return output;
	}

	public void setCloudInfoProvider(CloudResourceProvider provider) {
		this.provider = provider;
	}
	
	public void setBehavior(IDialogBehavior behavior){
		this.behavior = behavior;
	}
}
