/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.base.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.util.Messages;

public class EditTagDialog extends Dialog {
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");

	private String strSeparator = messages.getString("caption.title_separator");
	private String strName = messages.getString("word.name");
	private String strValue = messages.getString("word.value");
	private String strEditTagDialog = messages.getString("caption.edit_tag_dialog");
	private String msgMustFullyInput = messages.getString("message.must_fully_input");
	
	private Text txtName;
	private Text txtValue;

	private String name;
	private String value;

	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public EditTagDialog(Shell parentShell, String name, String value) {
		super(parentShell);
		this.name = name;
		this.value = value;
	}

	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public EditTagDialog(Shell parentShell) {
		super(parentShell);
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(3, false);
		gl_container.verticalSpacing = 10;
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);
		
		Label lblNewLabel = new Label(container, SWT.NONE);
		lblNewLabel.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblNewLabel.setText(strName + strSeparator);
		new Label(container, SWT.NONE);
		
		txtName = new Text(container, SWT.BORDER);
		txtName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblNewLabel_1 = new Label(container, SWT.NONE);
		lblNewLabel_1.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_1.setText(strValue + strSeparator);
		new Label(container, SWT.NONE);
		
		txtValue = new Text(container, SWT.BORDER);
		txtValue.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		ControlUtil.setRequired(new Control[]{txtName, txtValue});
		
		if (name != null) {
			txtName.setText(name);
		}
		
		if (value != null) {
			txtValue.setText(value);
		}

		return container;
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(strEditTagDialog);
	}
	
	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				true);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}
	
	@Override
	protected void okPressed() {
		if(txtName.getText().equals("") || txtValue.getText().equals("")){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					msgMustFullyInput);
			return;
		}

		name = txtName.getText();
		value = txtValue.getText();
		setReturnCode(OK);
		close();
	}
	
	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(450, 200);
	}

	public String getName() {
		return name;
	}

	public String getValue() {
		return value;
	}
}
