/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.base.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import org.eclipse.swt.custom.StyledText;

import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.presenter.ICloudInstance;

public class ShowPasswordDialog extends Dialog {
	
	private StyledText styledText;
	private String showText;
	private ICloudInstance instance;


	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	
	private String strSeparator = messages.getString("caption.title_separator");
	private String strFacilityId = messages.getString("word.facility_id");
	private String strFacilityName = messages.getString("word.facility_name");
	private String strInstanceId = messages.getString("word.instance_id");
	private String strInstanceName = messages.getString("word.instance_name");
	private String strShowPasswordDialog = messages.getString("caption.show_password_dialog");
	
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public ShowPasswordDialog(Shell parentShell) {
		super(parentShell);
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(2, false);
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);
		

		Label lblFacilityId = new Label(container, SWT.NONE | SWT.RIGHT);
		lblFacilityId.setText(strFacilityId + strSeparator);
		lblFacilityId.setLayoutData(new GridData(SWT.FILL, SWT.RIGHT, false, false, 1, 1));

		Text txtFacilityId = new Text(container, SWT.READ_ONLY);
		txtFacilityId.setText(instance.getFacilityId());
		txtFacilityId.setLayoutData(new GridData(SWT.FILL, SWT.LEFT, true, false, 1, 1));
		
		Label lblFacilityName = new Label(container, SWT.NONE | SWT.RIGHT);
		lblFacilityName.setText(strFacilityName + strSeparator);
		lblFacilityName.setLayoutData(new GridData(SWT.FILL, SWT.RIGHT, false, false, 1, 1));

		Text txtFacilityName = new Text(container, SWT.READ_ONLY);
		txtFacilityName.setText(instance.getFacilityName());
		txtFacilityName.setLayoutData(new GridData(SWT.FILL, SWT.LEFT, true, false, 1, 1));

		Label lblInstanceId = new Label(container, SWT.NONE | SWT.RIGHT);
		lblInstanceId.setText(strInstanceId + strSeparator);
		lblInstanceId.setLayoutData(new GridData(SWT.FILL, SWT.RIGHT, false, false, 1, 1));

		Text txtInstanceId = new Text(container, SWT.READ_ONLY);
		txtInstanceId.setText(instance.getInstanceId());
		txtInstanceId.setLayoutData(new GridData(SWT.FILL, SWT.LEFT, true, false, 1, 1));

		Label lblInstanceName = new Label(container, SWT.NONE | SWT.RIGHT);
		lblInstanceName.setText(strInstanceName + strSeparator);
		lblInstanceName.setLayoutData(new GridData(SWT.FILL, SWT.RIGHT, false, false, 1, 1));

		Text txtInstanceName = new Text(container, SWT.READ_ONLY);
		txtInstanceName.setText(instance.getInstanceName());
		txtInstanceName.setLayoutData(new GridData(SWT.FILL, SWT.LEFT, true, false, 1, 1));
		
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		
		Group grpWindowspassword = new Group(container, SWT.NONE);
		grpWindowspassword.setText("Password");
		grpWindowspassword.setLayout(new GridLayout(1, false));
		GridData gd_grpWindowspassword = new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1);
		gd_grpWindowspassword.heightHint = 110;
		grpWindowspassword.setLayoutData(gd_grpWindowspassword);
		
		styledText = new StyledText(grpWindowspassword, SWT.BORDER | SWT.WRAP | SWT.READ_ONLY);
		styledText.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		styledText.setText(showText);
		
		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
//		createButton(parent, IDialogConstants.CANCEL_ID,
//				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 360);
	}
	
	public void setText(String text){
		showText = text;
	}
	
	public void setInstance(ICloudInstance instance){
		this.instance = instance;
	}
	
	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(strShowPasswordDialog);
	}
}
