/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.cloudn.base.ui.views.actions;


import java.util.Iterator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;

import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.cloudn.base.presenter.JobTrackingService;
import com.clustercontrol.cloud.cloudn.base.ui.dialogs.AttachStorageFromStorageDialog;
import com.clustercontrol.cloud.presenter.ICloudStorage;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;


public class AttachStorageFromStorageAction extends SingleSelectionActionEx {
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");

	private String msgAttachStorageConfirm = messages.getString("message.confirm_some_action_to_subjects", new Object[]{"word.storage", "word.attach"});
	private String msgAttachStorageResult = messages.getString("message.some_command_has_been_accepted", new Object[]{"word.storage", "word.attach"});


	@Override
	protected void invoke(IAction action) throws InvocationException {
		ICloudStorage storage = (ICloudStorage)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		
		AttachStorageFromStorageDialog dialog = new AttachStorageFromStorageDialog(this.viewPart.getSite().getShell(), storage);

		if(dialog.open() == Window.OK){
			if (MessageDialog.openConfirm(
					null,
					Messages.getString("confirmed"),
					msgAttachStorageConfirm + "\n" + storage.getStorageId())){

				storage.attach(dialog.getInstanceId(), "dummy");

				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgAttachStorageResult);

				JobTrackingService.trackAttachStorage(this.viewPart, storage, dialog.getInstanceId());
			}
		}
	}

	protected boolean canEnabled(IStructuredSelection selection) {
		Iterator<?> iter = selection.iterator();
		while (iter.hasNext()) {
			ICloudStorage storage = (ICloudStorage)iter.next();
						
			if (storage.getStorageAttachment() != null || storage.getRegistState().equals(ICloudStorage.RegistStateType.deleted.name())) {
				return false;
			}
		}
		return true;
	}
}