/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.cloudn.base.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.cloudn.base.presenter.JobTrackingService;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.presenter.ICloudInstance.RegistStateType;
import com.clustercontrol.cloud.ui.views.InstancesView;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;

public class DeleteInstanceAction extends SingleSelectionActionEx {
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	
	private String strFacilityId = messages.getString("word.facility_id");
	private String strInstanceId = messages.getString("word.instance_id");
	private String msgDeleteInstanceConfirm = messages.getString("message.confirm_some_action_to_subjects", new Object[]{"word.instance", "word.remove"});
	private String msgDeleteInstanceResult = messages.getString("message.result_some_action_to_something", new Object[]{"word.instance", "word.remove"});

	@Override
	protected void invoke(IAction action){
		ICloudInstance instance = (ICloudInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		
		if (
			MessageDialog.openConfirm(
			null,
			Messages.getString("confirmed"),
			msgDeleteInstanceConfirm + "\n" + strFacilityId + " = " + instance.getFacilityId() + ", " + strInstanceId + " = " + instance.getInstanceId())
		){

			instance.getCloudInstanceManager().removeCloudInstance(instance.getCloudInstanceManager().getRegion().getAccountResource().getActiveUser().getRoleId(), instance.getRegion(), instance.getInstanceId());

			// 成功報告ダイアログを生成
			MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgDeleteInstanceResult);

			final InstancesView view = (InstancesView)viewPart;
			view.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					com.clustercontrol.action.FacilityTree.refresh();
				}
			});
			
			JobTrackingService.trackDeleteInstance(view, instance);
		}
	}

	@Override
	protected boolean canEnabled(IStructuredSelection selection) {
		ICloudInstance instance = (ICloudInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		return !RegistStateType.deleted.name().equals(instance.getRegistState());
	}
}