/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.presenter.AllPropertyObserver;
import com.clustercontrol.cloud.presenter.CollectionObserver2;
import com.clustercontrol.cloud.presenter.IElement;
import com.clustercontrol.cloud.presenter.PropertyId2;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;

public abstract class FilterlingViewPart<S, R extends IElement, E extends IElement , M> extends AsyncUpdateViewPart implements ISelectionListener {
	protected class ConcreteDataHolder implements DataHolder<List<M>, S> {
		private String viewId;
		private ISelection selection;
		
		public ConcreteDataHolder(String viewId, ISelection selection) {
			this.viewId = viewId;
			this.selection = selection;
		}
		@Override
		public S getTargetState() {
			return nextState;
		}
		@Override
		public S getCurrentState() {
			return currentState;
		}
		@Override
		public List<M> asyncGetData(S targetState) {
			try {
				CloudEndpoint endpoint = Activator.getEndpointManager().getEndpoint(CloudEndpoint.class);
				return getManagerElements(endpoint, targetState);
			}
			catch (Exception e) {
				if (e instanceof IllegalStateException) {
					throw (IllegalStateException)e;
				}
				throw new IllegalStateException(e);
			}
		}
		@Override
		public void syncSetData(S targetState, List<M> data) {
			successGetManagerData(targetState, data);
		}
		@Override
		public boolean isInitialized(S targetState) {
			return FilterlingViewPart.this.isInitialized(getRootElement(targetState));
		}
		@Override
		public boolean prepare() {
			return prepareFilterConditiion(viewId, selection);
		}
		@Override
		public void startAsyncCall(S targetState) {
			startGetManagerData(targetState);
		}
		@Override
		public void success() {
			updateNextState();
		}
		@Override
		public void error(Exception exception) {
			updateNextState(exception);
		}
		@Override
		public void failAsyncCall(S targetState, Exception exception) {
			failedGetManagerData(targetState, exception);
		}
		@Override
		public void failPrepareAsyncCall(Exception exception) {
			failedPrepareFilterConditiion(exception);
		}
	};

	private CollectionObserver2<E> elementObserver = new CollectionObserver2<E>() {
		@Override
		public void elementAdded(ElementAddedEvent<E> event) {
			event.getAddedElement().addPropertyObserver2(IElement.allProperty, propertyObserver);

			E element = event.getAddedElement();
			if (isMatch(element)) {
				elements.add(event.getAddedElement());
				getViewer().setInput(elements);

				FilterlingViewPart.this.getSite().getShell().getDisplay().syncExec(new Runnable() {
					@Override
					public void run() {
						getViewer().refresh(true);

						// アクションの状態を更新。
						ISelection selection = FilterlingViewPart.this.getViewer().getSelection();
						FilterlingViewPart.this.getSite().getSelectionProvider().setSelection(selection);
					}
				});
			}
		}
		@Override
		public void elementRemoved(ElementRemovedEvent<E> event) {
			event.getRemovedElement().removePropertyObserver2(IElement.allProperty, propertyObserver);

			elements.remove(event.getRemovedElement());
			getViewer().setInput(elements);
			
			FilterlingViewPart.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					getViewer().refresh(true);

					// アクションの状態を更新。
					ISelection selection = FilterlingViewPart.this.getViewer().getSelection();
					FilterlingViewPart.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
	};

	private AllPropertyObserver propertyObserver = new AllPropertyObserver() {
		@Override
		public void propertyChanged(ValueChangedEvent event) {
			FilterlingViewPart.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					getViewer().refresh(true);

					// アクションの状態を更新。
					ISelection selection = FilterlingViewPart.this.getViewer().getSelection();
					FilterlingViewPart.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
		
		@Override
		public void elementRemoved(ElementRemovedEvent event) {
			FilterlingViewPart.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					getViewer().refresh(true);

					// アクションの状態を更新。
					ISelection selection = FilterlingViewPart.this.getViewer().getSelection();
					FilterlingViewPart.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
		
		@Override
		public void elementAdded(ElementAddedEvent event) {
			FilterlingViewPart.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					getViewer().refresh(true);

					// アクションの状態を更新。
					ISelection selection = FilterlingViewPart.this.getViewer().getSelection();
					FilterlingViewPart.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
	};

	private List<E> elements = Collections.emptyList();

	private S currentState;

	private S nextState;

	protected abstract boolean prepareFilterConditiion(String viewId, ISelection selection);
	
	protected void failedPrepareFilterConditiion(Exception exception) {
		Logger logger = Logger.getLogger(this.getClass());
		logger.error(exception.getMessage(), exception);
		updateNextState(exception);
	}

	protected void updateNextState() {
		releaseElements();
		
		nextState();
		
		addElements();
	}

	protected void updateNextState(Exception exception) {
		releaseElements();
		
		nextState();

		getViewer().setInput(elements);
		
		updateStatus(exception);
	}

	protected void releaseElements() {
		// 次の情報を表示するための後始末。
		if (getCurrentState() != null) {
			removeRootListener(getRootElement(getCurrentState()));
		}
		for (E element: elements) {
			removeElementListener(element);
		}
		elements.clear();
	}
	
	protected void addElements() {
		elements = filterElements();
		
		for (E element: elements) {
			addElementListener(element);
		}

		if (currentState != null) {
			addRootListener(getRootElement(getCurrentState()));
		}

		getViewer().setInput(elements);

		updateStatus();
	}

	protected List<E> filterElements() {
		List<E> elements = Collections.emptyList();
		if (getCurrentState() != null) {
			elements = new ArrayList<E>();
			for (E element: getElements(getRootElement(getCurrentState()))) {
				if (isMatch(element)) {
					elements.add(element);
				}
			}
		}
		return elements;
	}

	protected abstract R getRootElement(S region);
	
	protected abstract List<E> getElements(R root);

	protected abstract PropertyId2<CollectionObserver2<E>> getPropertyId();

	protected void addRootListener(R rootElement) {
		rootElement.addPropertyObserver2(getPropertyId(), elementObserver);
	}

	protected void removeRootListener(R rootElement) {
		rootElement.removePropertyObserver2(getPropertyId(), elementObserver);
	}
	
	protected void addElementListener(E element) {
		element.addPropertyObserver2(IElement.allProperty, propertyObserver);
	}
	
	protected void removeElementListener(E element) {
		element.removePropertyObserver2(IElement.allProperty, propertyObserver);
	}
	
	protected void nextState() {
		currentState = nextState;
	}

	protected abstract boolean isMatch(E element);

	protected abstract List<M> getManagerElements(CloudEndpoint endpoint, S target) throws InvalidRole_Exception, InvalidUserPass_Exception, CloudManagerFault_Exception;

	protected abstract void setManagerElements(R rootElement, List<M> managerElements);

	protected abstract boolean isInitialized(R rootElement);

	protected void updateStatus() {
	}

	protected void updateStatus(Exception exception) {
	}

	protected void startGetManagerData(S target) {
	}

	protected void successGetManagerData(S targetState, List<M> managerElements) {
		setManagerElements(getRootElement(targetState), managerElements);
	}

	protected void failedGetManagerData(S targetState, Exception exception) {
		List<M> managerElements = Collections.emptyList();
		setManagerElements(getRootElement(targetState), managerElements);
		
		Logger logger = Logger.getLogger(this.getClass());
		if (exception != null) {
			logger.error(exception.getMessage(), exception);
		}
		else {
			logger.error("unexpected.");
		}
	}

	public R getCurrentRootElement() {
		if (currentState != null) {
			return getRootElement(currentState);
		}
		return null;
	}
	
	public List<E> getCurrentElements() {
		return elements;
	}
	
	@Override
	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
//		long before = System.currentTimeMillis();

		update(new ConcreteDataHolder(part.getSite().getId(), selection), false);

//		long after = System.currentTimeMillis();

//		StringBuilder sb = new StringBuilder();
//		sb.append("selectionChanged ").append("elapsedTime=").append(after - before).append("ms");
//		Logger logger = Logger.getLogger(this.getClass());
//		logger.debug(sb.toString());
	}
	
	protected S getCurrentState() {
		return currentState;
	}

	protected void setCurrentState(S currentState) {
		this.currentState = currentState;
	}

	protected S getNextState() {
		return nextState;
	}

	protected void setNextState(S nextState) {
		this.nextState = nextState;
	}
}