/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.ISelectionListener;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.commons.util.AccountControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.AccountControlUtil.NotFoundAccountResourceException;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.IElement;
import com.clustercontrol.cloud.presenter.INode;
import com.clustercontrol.cloud.presenter.IScope;
import com.clustercontrol.cloud.presenter.IAccountResource.IRegion;

public abstract class FilterlingViewPartByScopeAndAnother<R extends IElement, E extends IElement , M> extends FilterlingViewPart<IRegion, R, E, M> implements ISelectionListener, IAROrientedView {
	private MessageManager bundle_messages = MessageManager.getInstance("messages");

	private List<String> elementIds;

	private IAccountResource currentAccountResource;
	private IAccountResource nextAccountResource;

	protected Map<IRegion, String> resultMap = new HashMap<IRegion, String>();

	@Override
	protected boolean prepareFilterConditiion(String viweId, ISelection selection) {
		if (!(selection instanceof IStructuredSelection)) {
			return false;
		}

		if (viweId.equals(ScopeView.Id)) {
			IStructuredSelection sselection = (IStructuredSelection)selection;
			if (sselection.isEmpty()) {
				setNextState(null);
				return true;
			}
			
			IAccountResource accountResource = null;
			
			Object selected = sselection.getFirstElement();
			if (selected instanceof IScope) {
				IScope scope = (IScope)selected;
				
				switch(scope.getScopeType()) {
				case region:
					{
						accountResource = Activator.getDefault().getCloudResourceManager().getAccountResourceManager().getAccountResource(IScope.ScopeType.region.getAccountResourceId(scope));
						setNextState(accountResource != null ? accountResource.getRegion(IScope.ScopeType.region.getRegion(scope)): null);
					}
					break;
				case zone:
					{
						accountResource = Activator.getDefault().getCloudResourceManager().getAccountResourceManager().getAccountResource(IScope.ScopeType.region.getAccountResourceId(scope.getParent()));
						setNextState(accountResource != null ? accountResource.getRegion(IScope.ScopeType.region.getRegion(scope.getParent())): null);
					}
					break;
				case root:
					{
						setNextState(null);
					}
					break;
				case account_resource_scope:
					{
						accountResource = Activator.getDefault().getCloudResourceManager().getAccountResourceManager().getAccountResource(IScope.ScopeType.account_resource_scope.getAccountResourceId(scope));
						setNextState(null);
					}
					break;
				default:
					return false;
				}
			}
			else if (selected instanceof INode) {
				INode node = (INode)selected;
				accountResource = Activator.getDefault().getCloudResourceManager().getAccountResourceManager().getAccountResource(IScope.ScopeType.region.getAccountResourceId(node.getParent().getParent()));
				setNextState(accountResource.getRegion(IScope.ScopeType.region.getRegion(node.getParent().getParent())));
			}

			nextAccountResource = accountResource;
			if(nextAccountResource != null){
				try {
					if(!AccountControlUtil.isInitializedActiveUser(nextAccountResource.getAccountResourceId())){
						AccountControlUtil.selectActiveUser(getSite().getPage().findView(ScopeView.Id));
					}
				}
				catch (NotFoundAccountResourceException e) {
					throw new IllegalStateException();
				}
			}

			return true;
		}
		else if (viweId.equals(getSupportViewId())) {
			IStructuredSelection sselection = (IStructuredSelection)selection;
			if (sselection.isEmpty()) {
				elementIds = Collections.emptyList();
			}
			else {
				elementIds = new ArrayList<String>();
				Iterator<?> i = sselection.iterator();
				while (i.hasNext()) {
					Object selected = i.next();
					String elementId = getElementId(selected);
					if (elementId != null) {
						elementIds.add(elementId);
					}
				}
			}

			releaseElements();
			
			addElements();
		}
		
		return false;
	}

	protected abstract String getHeaderByElementId(IRegion region, List<String> elementIds);

	protected String getHeaderByRegion(IRegion region) {
		return bundle_messages.getString("word.region") + bundle_messages.getString("caption.title_separator") + region.getRegionName();
	}

	protected String getEmptyHeader() {
		return "";
	}

	protected abstract String getElementId(Object selected);
	
	@Override
	protected boolean isMatch(E element) {
		return	getCurrentState() != null && 
				isMatchRegion(getCurrentState(), element) &&
				isMatchElementIds(elementIds, element);
	}
	
	protected abstract boolean isMatchRegion(IRegion region, E element);

	protected abstract boolean isMatchElementIds(List<String> elementIds, E element);

	protected abstract Label getHeaderLabel();
	
	protected abstract String getSupportViewId();

	protected abstract Label getLeftFooter();
	
	protected abstract Label getRightFooter();

	@Override
	protected void failedPrepareFilterConditiion(Exception exception) {
		super.failedPrepareFilterConditiion(exception);
		
		getHeaderLabel().setText("");
		
		if (exception instanceof CloudModelException) {
			getLeftFooter().setText(((CloudModelException)exception).getMessage());
		}
		else {
			getLeftFooter().setText(bundle_messages.getString("word.fail"));
		}

		getRightFooter().setText(bundle_messages.getString("word.view_item_count") + bundle_messages.getString("caption.title_separator") + getCurrentElements().size());
	}
	
	@Override
	protected void successGetManagerData(IRegion targetState, List<M> managerElements) {
		super.successGetManagerData(targetState, managerElements);
		resultMap.put(targetState, bundle_messages.getString("word.success"));
	}

	@Override
	protected void failedGetManagerData(IRegion targetState, Exception exception) {
		super.failedGetManagerData(targetState, exception);
		resultMap.put(targetState, bundle_messages.getString("word.fail"));
	}
	
	@Override
	protected void startGetManagerData(IRegion region) {
		getLeftFooter().setText(bundle_messages.getString("caption.accessing_to", new String[]{region.getRegionName()}));
	}

	@Override
	protected void nextState() {
		IAccountResource oldAccountResource = currentAccountResource;

		if (getCurrentState() != getNextState()) {
			elementIds = Collections.emptyList();
		}
		super.nextState();

		currentAccountResource = nextAccountResource;
		
		// アカウントリソースが変更された場合に、ファイア。
		if (oldAccountResource != currentAccountResource) {
			firePropertyChange(Prop_AccountResource);
		}
	}

	@Override
	protected void updateStatus() {
		if (getCurrentState() != null) {
			if (!elementIds.isEmpty()) {
				getHeaderLabel().setText(getHeaderByElementId(getCurrentState(), elementIds));
			}
			else {
				getHeaderLabel().setText(getHeaderByRegion(getCurrentState()));
			}
		}
		else {
			getHeaderLabel().setText(getEmptyHeader());
		}

		getLeftFooter().setText(resultMap.get(getCurrentState()) == null ? "": resultMap.get(getCurrentState()));

		getRightFooter().setText(bundle_messages.getString("word.view_item_count") + bundle_messages.getString("caption.title_separator") + getCurrentElements().size());
	}

	@Override
	protected void updateStatus(Exception exception) {
		if (getCurrentState() != null) {
			if (!elementIds.isEmpty()) {
				getHeaderLabel().setText(getHeaderByElementId(getCurrentState(), elementIds));
			}
			else {
				getHeaderLabel().setText(getHeaderByRegion(getCurrentState()));
			}
		}
		else {
			getHeaderLabel().setText(getEmptyHeader());
		}


		getLeftFooter().setText(resultMap.get(getCurrentState()) == null ? "": resultMap.get(getCurrentState()));

		getRightFooter().setText(bundle_messages.getString("word.view_item_count") + bundle_messages.getString("caption.title_separator") + getCurrentElements().size());
	}

	public IRegion getActiveRegion() {
		return getCurrentState();
	}

	@Override
	public void update() {
		ISelection selection = getSite().getPage().getSelection(ScopeView.Id);
		update(new ConcreteDataHolder(ScopeView.Id, selection), true);
	}

	@Override
	public IAccountResource getCurrentAccountResource() {
		return currentAccountResource;
	}
}