/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;


import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.util.Messages;


public class RemoveCloudServiceAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.RemoveCloudServiceAction";

	private MessageManager messages = MessageManager.getInstance("messages");
	
	private String msgCloudServiceConfirm = messages.getString("message.confirm_some_action_to_something", new Object[]{"word.cloud_service", "word.remove"});
	private String msgCloudServiceResult = messages.getString("message.result_some_action_to_something", new Object[]{"word.cloud_service", "word.remove"});

	@Override
	protected void invoke(IAction action) throws InvocationException {
		
//		IStructuredSelection selection = (IStructuredSelection) this.viewPart.getSite().getSelectionProvider().getSelection();

		if (MessageDialog.openConfirm(
			null,
			Messages.getString("confirmed"),
			msgCloudServiceConfirm)) {
			
			
			
			// 成功報告ダイアログを生成
			MessageDialog.openInformation(
				null,
				Messages.getString("successful"),
				msgCloudServiceResult);
		}
		else {
			return;
		}
	}
}