/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn;

import com.clustercontrol.cloud.CloudManagerBaseService;
import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.CloudPlugin;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.IUserManagement;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.PluginFault;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.bean.CloudEndpoint;
import com.clustercontrol.cloud.bean.CloudRegion;
import com.clustercontrol.cloud.bean.CloudStorage;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.cloudn.CloudnOptionPropertyConstants;
import com.clustercontrol.cloud.cloudn.ErrorCode;
import com.clustercontrol.cloud.cloudn.factory.CloudnResourceManagement_FLAT;
import com.clustercontrol.cloud.cloudn.factory.CloudnResourceManagement_VPC;
import com.clustercontrol.cloud.cloudn.factory.CloudnUserManagement;
import com.clustercontrol.cloud.cloudn.factory.MigrationProcesser;
import com.clustercontrol.cloud.dao.CloudUserDao;
import com.clustercontrol.cloud.factory.ICloudServiceOperator;
import com.clustercontrol.cloud.factory.monitors.AutoDetectionManager;
import com.clustercontrol.cloud.factory.monitors.InstanceMonitorService;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.persistence.PersistenceUtil;
import com.clustercontrol.cloud.persistence.Transactional;
import com.clustercontrol.cloud.registry.AbstractObjectChangedListener;
import com.clustercontrol.cloud.registry.IObjectChangedListener;
import com.clustercontrol.cloud.registry.IObjectChangedService;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.cloud.util.proxy.IProxyStore;
import com.clustercontrol.ws.cloud.IWebServiceBase;
import com.clustercontrol.ws.cloudn.CloudnOptionEndpointImpl;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Query;
import org.apache.log4j.Logger;
import org.eclipse.jdt.annotation.Nullable;

public class CloudnManagerBaseService
extends CloudPlugin {
    public static final String id = CloudnManagerBaseService.class.getName();
    private static Optional<CloudnManagerBaseService> singleton = Optional.absent();

    public CloudnManagerBaseService() {
        CloudnManagerBaseService.setSingleton(this);
    }

    public Set<String> getDependency() {
        HashSet<String> set = new HashSet<String>();
        set.add(CloudManagerBaseService.class.getName());
        return set;
    }

    public void create() {
        Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
        logger.info((Object)("creating " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
        for (CloudnOptionPropertyConstants value : CloudnOptionPropertyConstants.values()) {
            logger.info((Object)(value.id + " = " + value.value() + " (" + value.defaultValue() + ")"));
        }
        logger.info((Object)("successful in creating " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
    }

    public void activate() {
        Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
        logger.info((Object)("starting " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
        logger.info((Object)("successful in starting " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
    }

    public void deactivate() {
        Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
        logger.info((Object)("stopping " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
        logger.info((Object)("successful in stopping " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
    }

    public void destroy() {
        Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
        logger.info((Object)("destroying " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
        logger.info((Object)("successful in destroying " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
    }

    @Nullable
    public static CloudnManagerBaseService getSingleton() {
        return singleton.isPresent() ? (CloudnManagerBaseService)((Object)singleton.get()) : null;
    }

    private static void setSingleton(CloudnManagerBaseService service) {
        singleton = Optional.of((Object)((Object)service));
    }

    public String getPluginId() {
        return id;
    }

    public void initialize() {
        Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
        logger.info((Object)("initializing " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
        ObjectRegistryService.registry().put(IUserManagement.class, (Object)"cloudn_vpc", CloudnUserManagement.class);
        ObjectRegistryService.registry().put(IUserManagement.class, (Object)"cloudn_flat", CloudnUserManagement.class);
        ObjectRegistryService.registry().put(IResourceManagement.class, (Object)"cloudn_vpc", CloudnResourceManagement_VPC.class);
        ObjectRegistryService.registry().put(IResourceManagement.class, (Object)"cloudn_flat", CloudnResourceManagement_FLAT.class);
        CloudManagerBaseService.getSingleton().publish("/HinemosWS/CloudnOptionEndpoint", (IWebServiceBase)new CloudnOptionEndpointImpl());
        String proxyHost = CloudnOptionPropertyConstants.cloudn_client_config_proxyHost.value();
        int proxyPort = Integer.valueOf(CloudnOptionPropertyConstants.cloudn_client_config_proxyPort.value());
        if (proxyHost != null && !proxyHost.isEmpty() && proxyPort > 0) {
            Matcher m;
            CloudEndpoint endpoint;
            List regions;
            Pattern pattern = Pattern.compile("^([^/]+).*$");
            String proxyUsername = CloudnOptionPropertyConstants.cloudn_client_config_proxyUsername.value();
            String proxyPassword = CloudnOptionPropertyConstants.cloudn_client_config_proxyPassword.value();
            IProxyStore proxyStore = (IProxyStore)ObjectRegistryService.registry().get(IProxyStore.class);
            ICloudServiceOperator service = (ICloudServiceOperator)ObjectRegistryService.registry().get(ICloudServiceOperator.class);
            ArrayList<String> destinations = new ArrayList<String>();
            try {
                regions = service.findCloudRegionsByService("cloudn_vpc");
            }
            catch (CloudManagerFault e) {
                throw new InternalManagerError((Throwable)e);
            }
            for (CloudRegion region : regions) {
                endpoint = region.getEndpoint("compute");
                if (endpoint == null) continue;
                m = pattern.matcher(endpoint.getLocation());
                if (m.matches()) {
                    destinations.add(m.group(1));
                    continue;
                }
                throw new InternalManagerError();
            }
            try {
                regions = service.findCloudRegionsByService("cloudn_flat");
            }
            catch (CloudManagerFault e) {
                throw new InternalManagerError((Throwable)e);
            }
            for (CloudRegion region : regions) {
                endpoint = region.getEndpoint("compute");
                if (endpoint == null) continue;
                m = pattern.matcher(endpoint.getLocation());
                if (m.matches()) {
                    destinations.add(m.group(1));
                    continue;
                }
                throw new InternalManagerError();
            }
            proxyStore.add(proxyHost, proxyPort, proxyUsername, proxyPassword, destinations.toArray(new String[destinations.size()]));
        }
        IObjectChangedService service = (IObjectChangedService)ObjectRegistryService.registry().get(IObjectChangedService.class);
        service.addObjectChangedListener(null, CloudUser.class, (IObjectChangedListener)new AbstractObjectChangedListener<CloudUser>(){

            public void postAdded(String type, CloudUser object) throws PluginFault {
                if (!CloudUserDao.CloudUserType.user.equals((Object)object.getCloudUserType())) {
                    return;
                }
                String serviceId = object.getTableData().getAccountResource().getCloudServiceId();
                if (!"cloudn_vpc".equals(serviceId) && !"cloudn_flat".equals(serviceId)) {
                    return;
                }
                CloudUserDao account = object.getTableData().getAccountResource().getAccount();
                if (!account.getAccessKey().equals(object.getAccessKey()) || !account.getSecretKey().equals(object.getSecretKey())) {
                    throw ErrorCode.CLOUDUSER_MUST_USE_SAME_PASSWORD_OF_ACCOUNT.cloudManagerFault(object.getCloudUserName());
                }
            }
        });
        service.addObjectChangedListener(null, CloudStorage.class, (IObjectChangedListener)new MigrationProcesser());
        AutoDetectionManager.getService().addListener(new AutoDetectionManager.AutoDetectionListner(){

            public void onPreUpdateBranch() {
            }

            public void onPostUpdateBranch() {
            }

            public void onPreUpdateRoot() {
            }

            public void onPostUpdateRoot() {
                Query query;
                EntityManagerEx em;
                try (PersistenceUtil.TransactionScope t = new PersistenceUtil.TransactionScope(Transactional.TransactionType.RequiredNew);){
                    em = SessionService.current().getEntityManagerEx();
                    query = em.createQuery("DELETE FROM CloudResourceStoreDao r WHERE r.resourceType = :resourceType AND r.cloudServiceId IN :cloudServiceId AND NOT EXISTS (SELECT r FROM CloudInstanceBackupDao b WHERE r.resourceId = b.instanceBackupId AND r.accountResourceId = b.accountResourceId AND r.region = b.region)");
                    query.setParameter("resourceType", (Object)CloudnResourceManagement_VPC.RT_InstanceBackup);
                    query.setParameter("cloudServiceId", Arrays.asList("cloudn_flat", "cloudn_vpc"));
                    query.executeUpdate();
                    t.complete();
                }
                t = new PersistenceUtil.TransactionScope(Transactional.TransactionType.RequiredNew);
                var2_2 = null;
                try {
                    em = SessionService.current().getEntityManagerEx();
                    query = em.createQuery("DELETE FROM CloudResourceStoreDao r WHERE r.resourceType = :resourceType AND r.cloudServiceId IN :cloudServiceId AND NOT EXISTS (SELECT r FROM CloudStorageBackupDao b WHERE r.resourceId = b.storageBackupId AND r.accountResourceId = b.accountResourceId AND r.region = b.region) ");
                    query.setParameter("resourceType", (Object)CloudnResourceManagement_VPC.RT_StorageBackup);
                    query.setParameter("cloudServiceId", Arrays.asList("cloudn_flat", "cloudn_vpc"));
                    query.executeUpdate();
                    t.complete();
                }
                catch (Throwable throwable) {
                    var2_2 = throwable;
                    throw throwable;
                }
                finally {
                    if (t != null) {
                        if (var2_2 != null) {
                            try {
                                t.close();
                            }
                            catch (Throwable x2) {
                                var2_2.addSuppressed(x2);
                            }
                        } else {
                            t.close();
                        }
                    }
                }
            }
        });
        InstanceMonitorService.getSingleton().addListener(new InstanceMonitorService.InstanceTraceListner(){

            public void onNotify(String accountResourceId, IResourceManagement.Instance instance) {
            }

            public void onError(String accountResourceId, String instanceId, Exception e) {
            }
        });
        logger.info((Object)("successful in initializing " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
    }
}

