/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn;

import com.clustercontrol.cloud.commons.PropValidator;
import com.clustercontrol.cloud.commons.PropertyContract;
import com.clustercontrol.commons.util.HinemosProperties;
import org.apache.log4j.Logger;
import org.eclipse.jdt.annotation.Nullable;

public enum CloudnOptionPropertyConstants implements PropertyContract
{
    cloudn_node_ip("hinemos.cloud.cloudn.node.ip", "private", (PropValidator)new PropValidator.StringValidator(new String[]{"public", "private"})),
    cloudn_private_cidr("hinemos.cloud.cloudn.private.cidr", "0.0.0.0/0"),
    cloudn_os_win_pattern("hinemos.cloud.cloudn.os.win.pattern", "(.*windows.*)|(.*win.*)|(.*microsoft.*)"),
    cloudn_os_linux_pattern("hinemos.cloud.cloudn.os.linux.pattern", "(.*linux.*)|(.*cent\\s*os.*)|(.*ubuntu.*)"),
    cloudn_flat_until_template_created("hinemos.cloud.cloudn.flat.untilTemplateCreated", String.valueOf(3600000), PropValidator.intValidator),
    cloudn_client_config_proxyHost("hinemos.cloud.cloudn.client.config.proxyHost", null),
    cloudn_client_config_proxyPassword("hinemos.cloud.cloudn.client.config.proxyPassword", null),
    cloudn_client_config_proxyPort("hinemos.cloud.cloudn.client.config.proxyPort", String.valueOf(-1), PropValidator.intValidator),
    cloudn_client_config_proxyUsername("hinemos.cloud.cloudn.client.config.proxyUsername", null);

    private PropValidator nullvalidator = new PropValidator(){

        public void validate(@Nullable String value) throws Exception {
        }
    };
    public final String id;
    public final String defaultValue;
    public final PropValidator validator;

    private CloudnOptionPropertyConstants(String id, String defaultValue) {
        this.id = id;
        this.defaultValue = defaultValue == null ? "" : defaultValue;
        this.validator = this.nullvalidator;
    }

    private CloudnOptionPropertyConstants(String id, String defaultValue, PropValidator validator) {
        this.id = id;
        this.defaultValue = defaultValue == null ? "" : defaultValue;
        this.validator = validator;
    }

    public String value() {
        String prop = HinemosProperties.getProperty((String)this.id, (String)this.defaultValue);
        try {
            this.validator.validate(prop);
        }
        catch (Exception e) {
            Logger logger = Logger.getLogger(CloudnOptionPropertyConstants.class);
            logger.error((Object)(this.id + " is invalid(" + prop + "), using default value(" + this.defaultValue + ")."));
            prop = this.defaultValue;
        }
        return prop;
    }

    public boolean match(@Nullable String value) {
        return this.value().equals(value);
    }

    public String defaultValue() {
        return this.defaultValue;
    }
}

