/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.util.proxy;

import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.cloud.util.proxy.IProxyStore;
import com.clustercontrol.cloud.util.proxy.Proxy;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;

public class ProxyAuthenticator {
    public static void setup() {
        ProxySelector.setDefault(new CloudOptinProxySelector(ProxySelector.getDefault()));
        Authenticator.setDefault(new CloudOptinAuthenticator());
    }

    private static class CloudOptinProxySelector
    extends ProxySelector {
        private final ProxySelector defaultSelector;

        public CloudOptinProxySelector(ProxySelector defaultSelector) {
            this.defaultSelector = defaultSelector;
        }

        @Override
        public List<java.net.Proxy> select(URI uri) {
            IProxyStore store = (IProxyStore)ObjectRegistryService.registry().get(IProxyStore.class);
            Proxy p = store.getProxy(uri.getHost());
            if (p != null) {
                if (!"http".equals(uri.getScheme()) && !"https".equals(uri.getScheme())) {
                    throw new InternalManagerError((Throwable)new UnknownHostException(uri.toString()));
                }
                java.net.Proxy proxy = new java.net.Proxy(Proxy.Type.HTTP, new InetSocketAddress(p.getHost(), p.getPort()));
                return Arrays.asList(proxy);
            }
            return this.defaultSelector.select(uri);
        }

        @Override
        public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        }
    }

    private static class CloudOptinAuthenticator
    extends Authenticator {
        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            IProxyStore store = (IProxyStore)ObjectRegistryService.registry().get(IProxyStore.class);
            Proxy p = store.getProxy(this.getRequestingURL().getHost());
            if (p != null) {
                return new PasswordAuthentication(p.getUser(), p.getPassword().toCharArray());
            }
            return null;
        }
    }
}

