/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.util.proxy;

import com.clustercontrol.cloud.util.proxy.IProxyEntry;
import com.clustercontrol.cloud.util.proxy.IProxyStore;
import com.clustercontrol.cloud.util.proxy.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ProxyStore
implements IProxyStore {
    private final Map<Integer, ProxyEntry> proxiesMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, Proxy> destinationsMap = Collections.synchronizedMap(new HashMap());
    private final AtomicInteger idGen = new AtomicInteger();

    @Override
    public int add(String proxyHost, int port, String user, String password, String ... host) {
        ProxyEntry entry = new ProxyEntry(this.idGen.incrementAndGet(), new Proxy(proxyHost, port, user, password), Arrays.asList(host));
        this.proxiesMap.put(entry.getId(), entry);
        this.refresh();
        return entry.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        Map<String, Proxy> map = this.destinationsMap;
        synchronized (map) {
            this.destinationsMap.clear();
            if (!this.proxiesMap.isEmpty()) {
                for (ProxyEntry value : this.proxiesMap.values()) {
                    for (String d : value.getDestination()) {
                        this.destinationsMap.put(d, value.getProxy());
                    }
                }
            }
        }
    }

    @Override
    public void remove(int id) {
        this.proxiesMap.remove(id);
        this.refresh();
    }

    @Override
    public IProxyEntry getEntry(int id) {
        return this.proxiesMap.get(id);
    }

    @Override
    public Proxy getProxy(String destination) {
        return this.destinationsMap.get(destination);
    }

    private static class ProxyEntry
    implements IProxyEntry {
        private int id;
        private Proxy proxy;
        private List<String> destination;

        public ProxyEntry(int id, Proxy proxy, List<String> destination) {
            this.id = id;
            this.proxy = proxy;
            this.destination = destination;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public Proxy getProxy() {
            return this.proxy;
        }

        @Override
        public List<String> getDestination() {
            return this.destination;
        }
    }
}

