/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.validation;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.IMessagesHolder;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.validation.CustomMethodValidator;
import com.clustercontrol.cloud.validation.MethodValidator;
import com.clustercontrol.cloud.validation.ValidationFault;
import java.lang.reflect.Method;
import javax.persistence.NoResultException;
import javax.persistence.Query;

public class AuthorizingValidator_get_clouduser
implements CustomMethodValidator {
    public void validate(Method method, Object[] params, String group, IMessagesHolder messages, MethodValidator.MethodValidationContext context) throws ValidationFault {
        try {
            EntityManagerEx em = SessionService.current().getEntityManagerEx();
            Query query = em.createQuery("SELECT DISTINCT c FROM CloudUserDao c JOIN c.accountResource a JOIN RoleEntity r ON c.roleId = r.roleId WHERE c.cloudUserId = :cloudUserId AND (:userId IN (SELECT u.userId FROM r.userEntities u) OR EXISTS (SELECT u FROM UserEntity u JOIN u.roleEntities r WHERE u.userId = :userId AND r.roleId = :ADMINISTRATORS) OR EXISTS (SELECT c2 FROM CloudUserDao c2 JOIN c2.accountResource a JOIN RoleEntity r ON c2.roleId = r.roleId JOIN r.userEntities u WHERE u.userId = :userId AND c2.accountResource.accountResourceId = c.accountResource.accountResourceId AND c2.cloudUserId = c2.accountResource.account.cloudUserId))");
            query.setParameter("userId", (Object)SessionService.current().getHinemosCredential().getUserId());
            query.setParameter("cloudUserId", (Object)((String)params[0]));
            query.setParameter("ADMINISTRATORS", (Object)"ADMINISTRATORS");
            try {
                query.getSingleResult();
            }
            catch (NoResultException e) {
                throw ErrorCode.CLOUDUSER_NOT_FOUND.cloudManagerFault((String)params[0]);
            }
        }
        catch (CloudManagerFault e) {
            throw new ValidationFault((Throwable)((Object)e));
        }
    }
}

