/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.validation;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.HinemosCredential;
import com.clustercontrol.cloud.ICloudContext;
import com.clustercontrol.cloud.IMessagesHolder;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.bean.CloudAccountResource;
import com.clustercontrol.cloud.bean.CloudService;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.factory.IAccountResourceOperator;
import com.clustercontrol.cloud.factory.ICloudServiceOperator;
import com.clustercontrol.cloud.factory.ICloudUserOperator;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.cloud.util.AccessDestination;
import com.clustercontrol.cloud.util.CloudContext;
import com.clustercontrol.cloud.validation.CustomMethodValidator;
import com.clustercontrol.cloud.validation.MethodValidator;
import com.clustercontrol.cloud.validation.ValidationFault;
import com.clustercontrol.commons.util.HinemosSessionContext;
import java.lang.reflect.Method;

public class AuthorizingValidator_role
implements CustomMethodValidator {
    public void validate(Method method, Object[] params, String group, IMessagesHolder messages, MethodValidator.MethodValidationContext context) throws ValidationFault {
        assert (params.length >= 1 && params[0].getClass() == String.class);
        try {
            String roleId = (String)params[0];
            HinemosCredential credential = SessionService.current().getHinemosCredential();
            ICloudUserOperator userOperator = (ICloudUserOperator)ObjectRegistryService.registry().get(ICloudUserOperator.class);
            CloudUser cloudUser = null;
            cloudUser = Boolean.TRUE.equals(HinemosSessionContext.instance().getProperty("isAdministrator")) ? userOperator.findCloudUserByRoleId(roleId) : userOperator.findCloudUserByUserIdAndRoleId(credential.getUserId(), roleId);
            IAccountResourceOperator operator = (IAccountResourceOperator)ObjectRegistryService.registry().get(IAccountResourceOperator.class);
            CloudAccountResource accountResource = operator.findCloudAccountResource(cloudUser.getAccountResourceId());
            ICloudServiceOperator serviceOperator = (ICloudServiceOperator)ObjectRegistryService.registry().get(ICloudServiceOperator.class);
            CloudService cloudService = serviceOperator.findCloudService(accountResource.getCloudServiceId());
            SessionService.current().set(ICloudContext.class, (Object)new CloudContext(new AccessDestination(cloudUser, cloudService, accountResource), null));
        }
        catch (CloudManagerFault e) {
            throw new ValidationFault((Throwable)((Object)e));
        }
    }
}

