/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud;

import com.clustercontrol.cloud.HinemosCredential;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.persistence.StdEntityManagerEx;
import com.clustercontrol.cloud.persistence.TransactionException;
import com.clustercontrol.cloud.util.HinemosUtil;
import com.clustercontrol.commons.util.HinemosSessionContext;
import com.clustercontrol.commons.util.JpaPersistenceConfig;
import com.clustercontrol.commons.util.JpaTransactionManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.persistence.EntityManager;
import javax.persistence.RollbackException;
import org.apache.log4j.Logger;

public class SessionService {
    private static ExecutorService executorService = SessionService.newCachedThreadPool("SessionContextPool");
    private static ScheduledExecutorService scheduledExecutorService = SessionService.newScheduledThreadPool(3, "SessionContextScheduler");
    private static ThreadLocal<Deque<SessionImpl>> deque = new ThreadLocal<Deque<SessionImpl>>(){

        @Override
        protected Deque<SessionImpl> initialValue() {
            return new LinkedList<SessionImpl>();
        }
    };
    private static List<ISessionInitializer> initializers = Collections.synchronizedList(new ArrayList());

    public static ISession current() {
        SessionImpl session = deque.get().peekFirst();
        if (session != null) {
            return session;
        }
        SessionService.offer();
        return deque.get().peekFirst();
    }

    public static ISession changeContext(ContextData context) {
        SessionService.poll();
        SessionService.offer(context);
        return deque.get().peekFirst();
    }

    public static void offer() {
        SessionImpl session = deque.get().peekFirst();
        SessionService.offer(session != null ? session.getContext() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void offer(ContextData context) {
        SessionImpl session = context == null ? new SessionImpl() : new SessionImpl(context);
        List<ISessionInitializer> list = initializers;
        synchronized (list) {
            for (ISessionInitializer initializer : initializers) {
                initializer.initialize(session);
            }
        }
        deque.get().offerFirst(session);
    }

    public static void poll() {
        ISession oldSession = deque.get().peekFirst();
        if (oldSession != null) {
            if (oldSession.isTransaction()) {
                throw new InternalManagerError("Transaction is active.");
            }
            oldSession.close();
        }
    }

    public static void addInitializer(ISessionInitializer initializer) {
        initializers.add(initializer);
    }

    public static ExecutorService newFixedThreadPool(int nThreads, final String poolName) {
        return new FinalizableDelegatedExecutorService(new ThreadPoolExecutorEx(nThreads, nThreads, 0L, TimeUnit.MICROSECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, poolName + "-thread-" + this.threadNumber.getAndIncrement());
            }
        }));
    }

    public static ExecutorService newCachedThreadPool(final String poolName) {
        return new FinalizableDelegatedExecutorService(new ThreadPoolExecutorEx(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, poolName + "-thread-" + this.threadNumber.getAndIncrement());
            }
        }));
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, final String poolName) {
        return new FinalizableDelegatedScheduledExecutorService(new ScheduledExecutorServiceEx(corePoolSize, new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, poolName + "-thread-" + this.threadNumber.getAndIncrement());
            }
        }));
    }

    public static ExecutorService newSingleThreadExecutor(final String poolName) {
        return new FinalizableDelegatedExecutorService(new ThreadPoolExecutorEx(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, poolName + "-thread-" + this.threadNumber.getAndIncrement());
            }
        }));
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(final String poolName) {
        return new FinalizableDelegatedScheduledExecutorService(new ScheduledExecutorServiceEx(1, new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, poolName + "-thread-" + this.threadNumber.getAndIncrement());
            }
        }));
    }

    public static void execute(Runnable command) {
        executorService.execute(command);
    }

    public static <T> Future<T> submit(Callable<T> task) {
        return executorService.submit(task);
    }

    public static <T> Future<T> submit(Runnable task, T result) {
        return executorService.submit(task, result);
    }

    public static Future<?> submit(Runnable task) {
        return executorService.submit(task);
    }

    public static ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return scheduledExecutorService.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    private static class SessionImpl
    implements ISession {
        private static Logger logger = Logger.getLogger(SessionImpl.class);
        private Map<Object, Boolean> states = new HashMap<Object, Boolean>();
        private Map<Class<?>, Object> objects = new HashMap();
        private Map<Object, Object> properties = new HashMap<Object, Object>();
        private HinemosCredential credential = new HinemosCredential();
        private EntityManager em;
        private EntityManagerEx emEx;
        private boolean transaction;
        private List<PreCommitAction> preCommitActions = new ArrayList<PreCommitAction>();
        private List<PostCommitAction> postCommitActions = new ArrayList<PostCommitAction>();
        private List<RolebackAction> rollbackActions = new ArrayList<RolebackAction>();

        private SessionImpl() {
            this.em = JpaPersistenceConfig.getHinemosEMFactory().createEntityManager();
            this.emEx = new StdEntityManagerEx(this.em);
            this.objects.put(EntityManager.class, this.em);
        }

        private SessionImpl(ContextData context) {
            this();
            HinemosSessionContext.instance().setProperty("loginUserId", (Object)context.accountName);
            HinemosSessionContext.instance().setProperty("isAdministrator", (Object)context.isAdministrator);
            this.states.putAll(context.states);
            this.objects.putAll(context.objects);
            this.properties.putAll(context.properties);
            this.credential = context.credential;
        }

        @Override
        public Object getProperty(Object key) {
            return this.properties.get(key);
        }

        @Override
        public void setProperty(Object key, Object value) {
            this.properties.put(key, value);
        }

        @Override
        public <T> T get(Class<T> clazz) {
            return clazz.cast(this.objects.get(clazz));
        }

        @Override
        public <T> void set(Class<T> clazz, T object) {
            this.objects.put(clazz, object);
        }

        @Override
        public void beginTransaction() {
            if (!this.emEx.getTransaction().isActive() && !this.transaction) {
                this.emEx.getTransaction().begin();
                this.transaction = true;
                this.preCommitActions.clear();
                this.postCommitActions.clear();
                this.rollbackActions.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commitTransaction() {
            if (this.transaction) {
                try {
                    try {
                        for (PreCommitAction preCommitAction : this.preCommitActions) {
                            RolebackAction rollback = preCommitAction.preCommit();
                            if (rollback == null) continue;
                            this.rollbackActions.add(0, rollback);
                        }
                        this.emEx.getTransaction().commit();
                    }
                    catch (Exception e1) {
                        if (!(e1 instanceof RollbackException)) {
                            try {
                                this.emEx.getTransaction().rollback();
                            }
                            catch (Exception exception) {
                                Logger.getLogger(this.getClass()).error((Object)exception.getMessage(), (Throwable)exception);
                            }
                        }
                        for (RolebackAction action : this.rollbackActions) {
                            try {
                                action.rollback();
                            }
                            catch (Exception e2) {
                                Logger.getLogger(this.getClass()).error((Object)e2.getMessage(), (Throwable)e2);
                            }
                        }
                        throw e1;
                    }
                    for (PostCommitAction postCommitAction : this.postCommitActions) {
                        postCommitAction.postCommit();
                    }
                }
                finally {
                    this.transaction = false;
                    this.preCommitActions.clear();
                    this.postCommitActions.clear();
                    this.rollbackActions.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rollbackTransaction() {
            if (this.transaction) {
                try {
                    this.emEx.getTransaction().rollback();
                }
                finally {
                    for (RolebackAction action : this.rollbackActions) {
                        try {
                            action.rollback();
                        }
                        catch (Exception e2) {
                            Logger.getLogger(this.getClass()).error((Object)e2.getMessage(), (Throwable)e2);
                        }
                    }
                    this.transaction = false;
                    this.preCommitActions.clear();
                    this.postCommitActions.clear();
                    this.rollbackActions.clear();
                }
            }
        }

        @Override
        public void flushPersistenceContext() {
            if (this.transaction) {
                try {
                    this.emEx.flush();
                }
                catch (Exception e1) {
                    for (RolebackAction action : this.rollbackActions) {
                        try {
                            action.rollback();
                        }
                        catch (Exception e2) {
                            Logger.getLogger(this.getClass()).error((Object)e2.getMessage(), (Throwable)e2);
                        }
                    }
                    throw e1;
                }
                finally {
                    this.transaction = false;
                    this.preCommitActions.clear();
                    this.postCommitActions.clear();
                    this.rollbackActions.clear();
                }
            }
        }

        @Override
        public void close() {
            this.emEx.close();
            this.release();
        }

        @Override
        public HinemosCredential getHinemosCredential() {
            return this.credential;
        }

        @Override
        public void setHinemosCredential(HinemosCredential credential) {
            this.credential = credential;
        }

        @Override
        public Map<Object, Object> getProperties() {
            return this.properties;
        }

        @Override
        public Map<Class<?>, ?> getObjects() {
            return this.objects;
        }

        @Override
        public EntityManagerEx getEntityManagerEx() {
            return this.emEx;
        }

        @Override
        public boolean isDebugEnbled() {
            return logger.isDebugEnabled();
        }

        @Override
        public boolean isTransaction() {
            return this.emEx != null && this.emEx.getTransaction().isActive() || this.transaction;
        }

        @Override
        public void addPreCommitAction(PreCommitAction action) {
            this.preCommitActions.add(action);
        }

        @Override
        public void addRollbackAction(RolebackAction action) {
            this.rollbackActions.add(0, action);
        }

        @Override
        public ContextData getContext() {
            ContextData data = new ContextData();
            data.states = new HashMap<Object, Boolean>(this.getStates());
            data.objects = new HashMap(this.getObjects());
            data.objects.remove(JpaTransactionManager.class);
            data.objects.remove(EntityManager.class);
            data.properties = new HashMap<Object, Object>(this.getProperties());
            data.credential = this.getHinemosCredential();
            data.accountName = (String)HinemosSessionContext.instance().getProperty("loginUserId");
            data.isAdministrator = (Boolean)HinemosSessionContext.instance().getProperty("isAdministrator");
            return data;
        }

        @Override
        public void addPostCommitAction(PostCommitAction action) {
            this.postCommitActions.add(action);
        }

        @Override
        public void setState(Object key, boolean state) {
            this.states.put(key, state);
        }

        @Override
        public boolean isState(Object key) {
            Boolean state = this.states.get(key);
            return state != null ? state : false;
        }

        @Override
        public Map<Object, Boolean> getStates() {
            return this.states;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            List list = initializers;
            synchronized (list) {
                for (ISessionInitializer initializer : initializers) {
                    initializer.close(this);
                }
            }
            ((Deque)deque.get()).pollFirst();
            HinemosUtil.shutdown();
        }
    }

    private static class ScheduledExecutorServiceEx
    extends ScheduledThreadPoolExecutor {
        public ScheduledExecutorServiceEx(int corePoolSize, RejectedExecutionHandler handler) {
            super(corePoolSize, handler);
        }

        public ScheduledExecutorServiceEx(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, threadFactory, handler);
        }

        public ScheduledExecutorServiceEx(int corePoolSize, ThreadFactory threadFactory) {
            super(corePoolSize, threadFactory);
        }

        public ScheduledExecutorServiceEx(int corePoolSize) {
            super(corePoolSize);
        }

        @Override
        protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> task) {
            return new DelegateRunnableScheduledFuture<V>(super.decorateTask(callable, task));
        }

        @Override
        protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
            return new DelegateRunnableScheduledFuture<V>(super.decorateTask(runnable, task));
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            SessionService.current().close();
        }
    }

    private static class DelegateRunnableScheduledFuture<V>
    extends DelegateRunnableFuture<V>
    implements RunnableScheduledFuture<V> {
        private RunnableScheduledFuture<V> task;

        public DelegateRunnableScheduledFuture(RunnableScheduledFuture<V> task) {
            super(task);
            this.task = task;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.task.getDelay(unit);
        }

        @Override
        public boolean isPeriodic() {
            return this.task.isPeriodic();
        }

        @Override
        public int compareTo(Delayed o) {
            return this.task.compareTo(o);
        }
    }

    private static class ThreadPoolExecutorEx
    extends ThreadPoolExecutor {
        @Override
        protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
            return new DelegateRunnableFuture<T>(super.newTaskFor(runnable, value));
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
            return new DelegateRunnableFuture<T>(super.newTaskFor(callable));
        }

        public ThreadPoolExecutorEx(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
        }

        public ThreadPoolExecutorEx(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        }

        public ThreadPoolExecutorEx(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        }

        public ThreadPoolExecutorEx(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            SessionService.current().close();
            new JpaTransactionManager().close();
        }
    }

    private static class DelegateRunnableFuture<V>
    implements RunnableFuture<V> {
        private ContextData context = SessionService.current().getContext();
        private RunnableFuture<V> task;

        public DelegateRunnableFuture(RunnableFuture<V> task) {
            this.task = task;
        }

        @Override
        public void run() {
            SessionService.changeContext(this.context);
            this.task.run();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.task.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.task.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.task.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.task.get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.task.get(timeout, unit);
        }

        public int hashCode() {
            return this.task.hashCode();
        }

        public boolean equals(Object obj) {
            return this.task.equals(obj);
        }

        public String toString() {
            return this.task.toString();
        }
    }

    private static class FinalizableDelegatedScheduledExecutorService
    extends DelegatedScheduledExecutorService {
        FinalizableDelegatedScheduledExecutorService(ScheduledExecutorService executor) {
            super(executor);
        }

        protected void finalize() {
            super.shutdown();
        }
    }

    private static class FinalizableDelegatedExecutorService
    extends DelegatedExecutorService {
        FinalizableDelegatedExecutorService(ExecutorService executor) {
            super(executor);
        }

        protected void finalize() {
            super.shutdown();
        }
    }

    private static class DelegatedScheduledExecutorService
    extends DelegatedExecutorService
    implements ScheduledExecutorService {
        private final ScheduledExecutorService e;

        DelegatedScheduledExecutorService(ScheduledExecutorService executor) {
            super(executor);
            this.e = executor;
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return this.e.schedule(command, delay, unit);
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            return this.e.schedule(callable, delay, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return this.e.scheduleAtFixedRate(command, initialDelay, period, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this.e.scheduleWithFixedDelay(command, initialDelay, delay, unit);
        }
    }

    private static class DelegatedExecutorService
    extends AbstractExecutorService {
        private final ExecutorService e;

        DelegatedExecutorService(ExecutorService executor) {
            this.e = executor;
        }

        @Override
        public void execute(Runnable command) {
            this.e.execute(command);
        }

        @Override
        public void shutdown() {
            this.e.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.e.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return this.e.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.e.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.e.awaitTermination(timeout, unit);
        }

        @Override
        public Future<?> submit(Runnable task) {
            return this.e.submit(task);
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return this.e.submit(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return this.e.submit(task, result);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return this.e.invokeAll(tasks);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this.e.invokeAll(tasks, timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return this.e.invokeAny(tasks);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.e.invokeAny(tasks, timeout, unit);
        }
    }

    public static class ContextData {
        private Map<Object, Boolean> states;
        private Map<Class<?>, Object> objects;
        private Map<Object, Object> properties;
        private HinemosCredential credential;
        private String accountName;
        private Boolean isAdministrator;
    }

    public static interface ISessionInitializer {
        public void initialize(ISession var1);

        public void close(ISession var1);
    }

    public static interface ISession {
        public void setState(Object var1, boolean var2);

        public boolean isState(Object var1);

        public Map<Object, Boolean> getStates();

        public Object getProperty(Object var1);

        public void setProperty(Object var1, Object var2);

        public Map<Object, Object> getProperties();

        public <T> T get(Class<T> var1);

        public <T> void set(Class<T> var1, T var2);

        public Map<Class<?>, ?> getObjects();

        public HinemosCredential getHinemosCredential();

        public void setHinemosCredential(HinemosCredential var1);

        public EntityManagerEx getEntityManagerEx();

        public void beginTransaction();

        public void commitTransaction();

        public void flushPersistenceContext();

        public void rollbackTransaction();

        public void close();

        public void addPreCommitAction(PreCommitAction var1);

        public void addPostCommitAction(PostCommitAction var1);

        public void addRollbackAction(RolebackAction var1);

        public boolean isTransaction();

        public boolean isDebugEnbled();

        public ContextData getContext();
    }

    public static interface RolebackAction {
        public void rollback() throws TransactionException;
    }

    public static interface PostCommitAction {
        public void postCommit() throws TransactionException;
    }

    public static interface PreCommitAction {
        public RolebackAction preCommit() throws TransactionException;
    }
}

