/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.persistence;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.clustercontrol.cloud.SessionService;

@Retention(RetentionPolicy.RUNTIME)  
@Target(ElementType.METHOD)
@ProcessedBy(ApplyUserName.ApplyUserNameProcessor.class)
public @interface ApplyUserName {
	public class ApplyUserNameProcessor extends AbstractProcessor<ApplyUserName> {
		@Override
		public void prePersist(Object entity) throws Exception {
			setMethod.invoke(entity, SessionService.current().getHinemosCredential().getUserId());
		}
		@Override
		public void preUpdate(Object entity) throws Exception {
			if (!annotation.onlyPersist()) {
				setMethod.invoke(entity, SessionService.current().getHinemosCredential().getUserId());
			}
		}
	}
	
	boolean onlyPersist() default false;
}
