/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.registry;

import com.clustercontrol.cloud.PluginFault;



public interface IObjectChangedService {
	<T> void addObjectChangedListener(String type, Class<T> clazz, IObjectChangedListener<T> listener);
	<T> void removeObjectChangedListener(String type, Class<T> clazz, IObjectChangedListener<T> listener);

	<T> void firePreAddedEvent(String type, Class<T> clazz, T object) throws PluginFault;
	<T> void firePostAddedEvent(String type, Class<T> clazz, T object) throws PluginFault;
	<T> void firePreRemovedEvent(String type, Class<T> clazz, T object) throws PluginFault;
	<T> void firePostRemovedEvent(String type, Class<T> clazz, T object) throws PluginFault;
	<T> void firePreModifiedEvent(String type, Class<T> clazz, T object) throws PluginFault;
	<T> void firePostModifiedEvent(String type, Class<T> clazz, T object) throws PluginFault;
}
