/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.util;

import java.util.Arrays;
import java.util.Iterator;


public class Tuple implements Iterable<Object> {
	private Object[] values;

	private Tuple(Object...values) {
		this.values = values;
	}

	public Object get(int i) {
		return values[i];
	}
	
	public int count() {
		return values.length;
	}

	@SuppressWarnings("unchecked")
	public <X> X get(int i, Class<X> type) {
		return (X)get(i);
	}

	public Object[] toArray() {
		return values;
	}

	public static Tuple build(Object...values) {
		return new Tuple(values);
	}

	@Override
	public Iterator<Object> iterator() {
		return new Iterator<Object>() {
			private int pos = 0;
			@Override
		    public boolean hasNext() {
		    	return pos < Tuple.this.values.length;
		    }
			@Override
		    public Object next() {
				return Tuple.this.values[pos];
		    }
			@Override
		    public void remove() {
		    	throw new UnsupportedOperationException();
		    }
		};
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + Arrays.hashCode(values);
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Tuple other = (Tuple) obj;
		if (!Arrays.equals(values, other.values))
			return false;
		return true;
	}
}
