/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.factory;

import java.util.Collections;
import java.util.List;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.cloudn.util.AuthorizingUtilEx;
import com.clustercontrol.cloud.cloudn.util.CloudnConstants;
import com.clustercontrol.cloud.dao.CloudUserDao;
import com.clustercontrol.cloud.factory.ICloudServiceOperator;
import com.clustercontrol.cloud.factory.ICloudUserOperator;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.cloud.util.CloudCredential;
import com.clustercontrol.cloud.util.ResourceRegion;
import com.google.common.base.Preconditions;

@NonNullByDefault(false)
public abstract class CloudnResourceManagementBase implements IResourceManagement, CloudnConstants {
	private IRegion region;
	private ICredential credential;
	private IStore store;

	public void setAccessDestination(ICredential credential, IRegion region) {
		this.region = region;
		this.credential = credential;
	}
	
	protected abstract String getComputeId();
	
	protected abstract String getServiceId();
	
	protected abstract String getDefaultRegion();

	public @NonNull ICredential getCledential() {
		if (this.credential == null) {
			if (SessionService.current().getHinemosCredential().getUserId() != null) {
				List<CloudUserDao> users = Collections.emptyList();
				try {
					users = AuthorizingUtilEx.getCloudUsersByCloudService(SessionService.current().getHinemosCredential().getUserId(), getServiceId());
				} catch (CloudManagerFault e) {
					throw new InternalManagerError(e.getMessage(), e.getErrorCode(), e);
				}
				if (!users.isEmpty()) {
					try {
						this.credential = new CloudCredential(ObjectRegistryService.registry().get(ICloudUserOperator.class).findCloudUser(users.get(0).getId()));
					} catch (CloudManagerFault e) {
						throw new InternalManagerError(e.getMessage(), e.getErrorCode(), e);
					}
				}
				else {
					throw new InternalManagerError();
				}
			}
			else {
				throw new InternalManagerError();
			}
		}
		return Preconditions.checkNotNull(credential);
	}
	public @NonNull IRegion getRegion() {
		if (this.region == null) {
			try {
				this.region = new ResourceRegion(ObjectRegistryService.registry().get(ICloudServiceOperator.class).findCloudRegion(getServiceId(), getDefaultRegion()));
			} catch (CloudManagerFault e) {
				throw new InternalManagerError(e.getMessage(), e.getErrorCode(), e);
			}
		}
		return Preconditions.checkNotNull(region);
	}
	public void setStore(IStore store) {
		this.store = store;
	}
	public @NonNull IStore getStore() {
		return Preconditions.checkNotNull(store);
	}
	public void disconnect() {
		
	}
}
